package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import amf.client.model.StrField;
import amf.client.model.domain.OAuth2Settings;
import org.mule.connectivity.restconnect.internal.model.security.naming.OAS2Oauth2Flows;
import org.mule.connectivity.restconnect.internal.model.security.naming.RAMLOauth2Flows;

public class AMFOauth2FlowsNaming {

    public static boolean isAuthorizationCode(OAuth2Settings oAuth2Settings){
        if(oAuth2Settings.authorizationGrants() != null && oAuth2Settings.authorizationGrants().size() > 0){
            for(StrField grant : oAuth2Settings.authorizationGrants()){
                if(RAMLOauth2Flows.AUTHORIZATION_CODE.equalsIgnoreCase(grant.value())){
                    return true;
                }
            }
        }

        if(oAuth2Settings.flow().nonEmpty()){
            return OAS2Oauth2Flows.ACCESS_CODE.equalsIgnoreCase(oAuth2Settings.flow().value());
        }

        return false;
    }

    public static boolean isClientCredentials(OAuth2Settings oAuth2Settings){
        if(oAuth2Settings.authorizationGrants() != null && oAuth2Settings.authorizationGrants().size() > 0){
            for(StrField grant : oAuth2Settings.authorizationGrants()){
                if(RAMLOauth2Flows.CLIENT_CREDENTIALS.equalsIgnoreCase(grant.value())){
                    return true;
                }
            }
        }

        if(oAuth2Settings.flow().nonEmpty()){
            return OAS2Oauth2Flows.APPLICATION.equalsIgnoreCase(oAuth2Settings.flow().value());
        }

        return false;
    }
}
