package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.naming.OAS2SecuritySchemes;
import org.mule.connectivity.restconnect.internal.model.security.naming.RAMLSecuritySchemes;

import java.util.Arrays;

public class AMFSecuritySchemesNaming {

    public static boolean isOauth1(String name){
        return RAMLSecuritySchemes.OAUTH1.equalsIgnoreCase(name);
    }

    public static boolean isOauth2(String name){
        return OAS2SecuritySchemes.OAUTH2.equalsIgnoreCase(name) || RAMLSecuritySchemes.OAUTH2.equalsIgnoreCase(name);
    }

    public static boolean isPassThrough(String name){
        return RAMLSecuritySchemes.PASS_THROUGH.equalsIgnoreCase(name);
    }

    public static boolean isApiKey(String name){
        return Arrays.stream(OAS2SecuritySchemes.API_KEY).anyMatch(x -> x.equalsIgnoreCase(name));
    }

    public static boolean isBasicAuth(String name){
        return OAS2SecuritySchemes.BASIC.equalsIgnoreCase(name) || RAMLSecuritySchemes.BASIC.equalsIgnoreCase(name);
    }

    public static boolean isDigestAuth(String name){
        return RAMLSecuritySchemes.DIGEST_AUTHENTICATION.equalsIgnoreCase(name);
    }

    public static boolean isJwtAuth(String name) {
        return APISecurityScheme.JWT.equalsIgnoreCase(name) || APISecurityScheme.CUSTOM_JWT.equalsIgnoreCase(name);
    }

    public static boolean isCustom(String name){
        return !OAS2SecuritySchemes.BASIC.equalsIgnoreCase(name) &&
                !AMFSecuritySchemesNaming.isApiKey(name) &&
                !OAS2SecuritySchemes.OAUTH2.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.BASIC.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.OAUTH1.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.OAUTH2.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.PASS_THROUGH.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.DIGEST_AUTHENTICATION.equalsIgnoreCase(name) &&
                !AMFSecuritySchemesNaming.isJwtAuth(name);
    }
}
