package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;

import java.util.Optional;

import static com.google.common.base.CaseFormat.LOWER_UNDERSCORE;
import static com.google.common.base.CaseFormat.UPPER_CAMEL;
import static java.lang.String.format;
import static org.apache.commons.lang.WordUtils.capitalizeFully;
import static org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils.getXmlName;

public class ConfigurationUtil {
    public static final String DEFAULT_GROUP_ID = "org.mule.modules.extensions";

    public static String buildBasePackage(final RestConnectAPIModel model, final String name) {
        return Optional.ofNullable(model.getCustomPackage()).orElse(
                format("%s.%s", Optional.ofNullable(model.getGroupId()).orElse(DEFAULT_GROUP_ID),
                        UPPER_CAMEL.to(LOWER_UNDERSCORE, name).replace("_", ".")));
    }

    public static String buildApiName(final RestConnectAPIModel model) {
        return capitalizeFully(getXmlName(model.getApiName()).replace("-connector", ""));
    }
}
