package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

import static com.google.common.base.CaseFormat.LOWER_UNDERSCORE;
import static com.google.common.base.CaseFormat.UPPER_CAMEL;
import static java.lang.String.format;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang.WordUtils.capitalizeFully;
import static org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils.getXmlName;

public class Extension extends ExtensionEntity {
    private final String name;
    private final String category;
    private final List<Config> configs;
    private final String basePackage;
    private final String xml;
    private final String testUrl;
    private final List<ErrorType> errorTypes;

    public Extension(RestConnectAPIModel model, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.name = ConfigurationUtil.buildApiName(model);
        this.category = Optional.ofNullable(model.getCategory()).map(ConnectorCategory::name).orElse(null);
        this.basePackage = ConfigurationUtil.buildBasePackage(model, name);
        this.xml = UPPER_CAMEL.to(LOWER_UNDERSCORE, name).replace("_", "-");
        this.testUrl = null;
        this.errorTypes = new ArrayList<>();
        this.configs = Stream.of(new Config(model, sourcesPath, resourcesPath, context)).collect(toList());
    }

    public String getName() {
        return name;
    }

    public String getCategory() {
        return category;
    }

    public String getBasePackage() {
        return basePackage;
    }

    public String getXml() {
        return xml;
    }

    public String getTestUrl() {
        return testUrl;
    }

    public List<ErrorType> getErrorTypes() {
        return errorTypes;
    }

    public List<Config> getConfigs() {
        return configs;
    }

    @Override
    public void generate() {
        applyTemplate("templates/sdk/extension/Extension.vm", format("internal/extension/%sExtension.java", name));
        applyTemplate("templates/sdk/connection/Connection.vm", format("internal/connection/%sConnection.java", name));
        applyTemplate("templates/sdk/error/ErrorTypes.vm", format("internal/error/%sErrorTypes.java", name));
        applyTemplate("templates/sdk/error/ErrorTypeProvider.vm", format("internal/error/%sErrorTypeProvider.java", name));
        configs.forEach(Config::generate);
    }
}
