package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

import static com.google.common.base.CaseFormat.*;
import static java.lang.String.format;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;
import static org.mule.connectivity.restconnect.internal.util.FileGenerationUtils.writeSchema;

public class Operation extends ExtensionEntity {
    private final String name;
    private final String httpMethod;
    private final String relativePath;
    private final String summary;
    private final String lowerCaseName;
    private final List<Parameter> pathParameters;
    private final List<Parameter> queryParameters;
    private final List<Parameter> headers;
    private final Content content;
    private String resultSchemaFile;
    private String resultSchemaType;

    public Operation(org.mule.connectivity.restconnect.internal.model.operation.Operation model, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        Function<org.mule.connectivity.restconnect.internal.model.parameter.Parameter, Parameter> parameterAdapter = parameter -> new Parameter(UPPER_UNDERSCORE.to(LOWER_CAMEL, parameter.getInternalName().replace("-", "_")), parameter.getTypeDefinition(), sourcesPath, resourcesPath, context);
        this.name = UPPER_UNDERSCORE.to(UPPER_CAMEL, model.getCanonicalName());
        this.lowerCaseName = UPPER_UNDERSCORE.to(LOWER_CAMEL, model.getCanonicalName());
        this.httpMethod = model.getHttpMethod().toLowerCase();
        this.relativePath = model.getUri();
        this.summary = Optional.ofNullable(model.getDescription()).map(value -> value
                .replace("\"", "\\\"")
                .replace("\n", "\\n")).orElse(null);
        this.pathParameters = model.getUriParameters().stream().map(parameterAdapter).collect(toList());
        this.queryParameters = model.getQueryParameters().stream().map(parameterAdapter).collect(toList());
        this.headers = model.getHeaders().stream().map(parameterAdapter).collect(toList());
        this.content = Optional.ofNullable(model.getInputMetadata()).map(typeDefinition -> new Content(lowerCaseName, typeDefinition, resourcesPath, sourcesPath, resourcesPath, context)).orElse(null);


        if(model.getOutputMetadata() != null && !(model.getOutputMetadata().getSource() instanceof PrimitiveTypeSource)){
            this.resultSchemaFile = Optional.ofNullable(model.getOutputMetadata()).map(TypeDefinition::getSource).map(source -> writeSchema(source, format("%s-schema", name), resourcesPath)).orElse(null);
            this.resultSchemaType = Optional.ofNullable(resultSchemaFile)
                    .map(value -> LOWER_CAMEL.to(UPPER_UNDERSCORE, value.substring(value.lastIndexOf(".") + 1)))
                    .orElse(null);
        }

    }

    public String getName() {
        return name;
    }

    public String getSummary() {
        return summary;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public String getLowerCaseName() {
        return lowerCaseName;
    }

    public String getRelativePath() {
        return relativePath;
    }

    public List<Parameter> getPathParameters() {
        return pathParameters;
    }

    public List<Parameter> getQueryParameters() {
        return queryParameters;
    }

    public List<Parameter> getHeaders() {
        return headers;
    }

    public Content getContent() {
        return content;
    }

    public String getResultSchemaFile() {
        return resultSchemaFile;
    }

    public String getResultSchemaType() {
        return resultSchemaType;
    }

    public List<Parameter> getParameters() {
        return concat(concat(pathParameters.stream(), queryParameters.stream()), concat(headers.stream(), Optional.ofNullable(content).map(Stream::of).orElseGet(Stream::of))).collect(toList());
    }

    @Override
    public void generate() {
        applyTemplate("templates/sdk/operation/Operation.vm", format("internal/operation/%sOperation.java", name));
    }
}
