package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

import static com.google.common.base.CaseFormat.LOWER_CAMEL;
import static com.google.common.base.CaseFormat.UPPER_CAMEL;
import static java.lang.String.format;
import static org.mule.connectivity.restconnect.internal.util.TemplateUtils.toUpperCamel;

public class Parameter extends ExtensionEntity {
    private final String name;
    private final String type;
    private final String summary;
    private final boolean optional;
    private final String defaultValue;
    private final List<String> allowedValues;
    private final String displayName;

    public Parameter(String name, TypeDefinition typeDefinition, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.name = name;
        this.displayName = LOWER_CAMEL.to(UPPER_CAMEL, Optional.ofNullable(typeDefinition.getAnnotatedDisplayName()).orElse(name));
        this.type = typeDefinition.isArrayType() ? "List<String>" : "String";
        this.summary = Optional.ofNullable(typeDefinition.getDescription()).map(value -> value
                .replace("\"", "\\\"")
                .replace("\n", "\\n")).orElse(null);
        this.optional = !typeDefinition.isRequired();
        this.defaultValue = typeDefinition.getDefaultValue();
        this.allowedValues = typeDefinition.getEnumValues();
    }

    public String getName() {
        return name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getType() {
        return type;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public String getSummary() {
        return summary;
    }

    public boolean isOptional() {
        return optional;
    }

    public List<String> getAllowedValues() {
        return allowedValues;
    }

    @Override
    public void generate() {
        Optional.ofNullable(allowedValues).filter(list -> list.size() > 1).ifPresent(values -> applyTemplate("templates/sdk/metadata/FixedValuesValueProvider.vm", format("internal/metadata/%sValueProvider.java", toUpperCamel(name))));
    }
}
