package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit;

import org.mule.connectivity.restconnect.internal.model.security.*;

import java.util.Map;
import java.util.Optional;

public abstract class DevKitSecuritySchemeDecorator {

    private APISecurityScheme apiSecurityScheme;
    private final String configName;
    private String configNameSufix = "";

    public DevKitSecuritySchemeDecorator(APISecurityScheme securityScheme, Map<APISecurityScheme, String> securitySchemesNames){
        this.apiSecurityScheme = securityScheme;
        this.configName = buildConfigName(securityScheme, securitySchemesNames);
    }

    private String buildConfigName(APISecurityScheme securityScheme, Map<APISecurityScheme, String> securitySchemesNames) {
        if (securitySchemesNames.isEmpty()){
            securitySchemesNames.put(securityScheme, this.getDefaultConfigName());
        }

        Optional<APISecurityScheme> existingScheme = securitySchemesNames.keySet().stream().filter(x -> x.equals(securityScheme)).findFirst();
        if(existingScheme.isPresent()){
            //If this scheme exists in the static list, we use the same name.
            return securitySchemesNames.get(existingScheme.get());
        }
        else {
            //If this scheme does not exist, we create a new one.
            String configName = this.getDefaultConfigName();
            String nameCandidate = configName;

            Integer i = 2;
            while (securitySchemesNames.containsValue(nameCandidate)){
                this.configNameSufix = i.toString();
                nameCandidate = configName + configNameSufix;
                i ++;
            }

            //Add the created name in the static list
            securitySchemesNames.put(securityScheme, nameCandidate);
            return nameCandidate;
        }
    }

    public APISecurityScheme getApiSecurityScheme() {
        return apiSecurityScheme;
    }

    public String getConfigName() {
        return configName;
    }

    public String getConfigNameSufix() {
        return configNameSufix;
    }

    public abstract String getTemplateLocation();

    public abstract String getDefaultConfigName();
}
