/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.type;

import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public abstract class TypeDefinitionDecorator {
    protected final TypeDefinition typeDefinition;
    private final String externalName;
    private final String internalName;

    public TypeDefinitionDecorator(String externalName, String internalName, TypeDefinition typeDefinition) {
        this.externalName = externalName;
        this.internalName = internalName;
        this.typeDefinition = typeDefinition;
    }

    public TypeDefinitionDecorator(TypeDefinition typeDefinition) {
        this.externalName = null;
        this.internalName = null;
        this.typeDefinition = typeDefinition;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean hasMediaType() {
        return this.typeDefinition.getMediaType() != null;
    }

    public String getMediaType() {
        return this.typeDefinition.getMediaType() == null ? null : this.typeDefinition.getMediaType().toString();
    }

    public boolean isRequired() {
        return !this.hasDefaultValue() && this.typeDefinition.isRequired();
    }

    public String getDescription() {
        return this.typeDefinition.getDescription();
    }

    public String getDefaultValue() {
        return this.typeDefinition.getDefaultValue();
    }

    public boolean hasDefaultValue() {
        return this.typeDefinition.getDefaultValue() != null && StringUtils.isNotBlank((CharSequence)this.typeDefinition.getDefaultValue());
    }

    public String getExample() {
        return this.typeDefinition.getExample();
    }

    public boolean isPrimitiveType() {
        return this.typeDefinition.getSource() instanceof PrimitiveTypeSource;
    }

    public boolean isUnionType() {
        return this.typeDefinition.isUnionType();
    }

    public boolean isArrayType() {
        return this.typeDefinition.isArrayType();
    }

    public boolean isEnumType() {
        return this.typeDefinition.isEnum();
    }

    public String getAnnotatedParameterName() {
        return this.typeDefinition.getAnnotatedDisplayName();
    }
}

