/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Operation;
import amf.client.model.domain.WebApi;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFSecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;

public class AMFOperationGenerator {
    public static org.mule.connectivity.restconnect.internal.model.operation.Operation generateOperation(WebApi api, EndPoint endPoint, Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        String friendlyName = AMFParserUtil.getMethodDisplayName(operation);
        String annotatedName = AMFParserUtil.getAnnotatedOperationName(operation);
        return new OperationBuilder().withFriendlyName(friendlyName).withAnnotatedDisplayName(StringUtils.isNotBlank((CharSequence)annotatedName) ? annotatedName : friendlyName).withCanonicalName(AMFParserUtil.getCanonicalOperationName(endPoint, operation, friendlyName)).withDescription(AMFOperationGenerator.buildOperationDescription(endPoint, operation)).withHttpMethod(HTTPMethod.fromString(operation.method().value())).withUri(endPoint.path().value()).withUriParams(AMFOperationGenerator.buildUriParams(endPoint, jsonSchemaPool)).withQueryParams(AMFOperationGenerator.buildQueryParams(operation, jsonSchemaPool)).withHeaders(AMFOperationGenerator.buildHeaders(operation, jsonSchemaPool)).withInputMetadata(AMFTypeDefinitionFactory.buildInputMetadata(operation, jsonSchemaPool)).withOutputMetadata(AMFTypeDefinitionFactory.buildOutputMetadata(operation, jsonSchemaPool)).withSecuritySchemes(AMFSecuritySchemeFactory.getSchemesForOperation(endPoint, operation, jsonSchemaPool)).withUserSelectedSecuritySchemes(AMFParserUtil.isUserSelectedSecuritySchemes(endPoint, operation, api)).build();
    }

    private static String buildOperationDescription(EndPoint endPoint, Operation operation) {
        return operation.description().nonEmpty() ? operation.description().value() : endPoint.description().value();
    }

    private static List<Parameter> buildUriParams(EndPoint endPoint, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        return AMFParserUtil.getParameterList(endPoint.parameters(), ParameterType.URI, jsonSchemaPool);
    }

    private static List<Parameter> buildQueryParams(Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if (operation.request() != null) {
            return AMFParserUtil.getParameterList(operation.request().queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        }
        return new ArrayList<Parameter>();
    }

    private static List<Parameter> buildHeaders(Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if (operation.request() != null) {
            return AMFParserUtil.getParameterList(operation.request().headers(), ParameterType.HEADER, jsonSchemaPool);
        }
        return new ArrayList<Parameter>();
    }
}

