/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.ModelDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorMergedSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecorator;

public class SmartConnectorModelDecorator
extends ModelDecorator {
    public static final String DEFAULT_GROUP_ID = "org.mule.modules.extensions";
    public static final String DEFAULT_ARTIFACT_PREFIX = "mule-module-";
    private final List<SmartConnectorOperationDecorator> decoratedOperations;
    private final HashMap<APISecurityScheme, String> securitySchemesNames = new HashMap();
    private final SmartConnectorMergedSchemeDecorator mergedScheme;
    private final boolean hasOauthScheme;

    public SmartConnectorModelDecorator(RestConnectAPIModel model) {
        super(model);
        this.decoratedOperations = this.buildDecoratedOperations();
        this.mergedScheme = this.buildMergedSecurityScheme();
        this.hasOauthScheme = this.securitySchemesNames.keySet().stream().anyMatch(x -> x.getSchemeName().equals("OAuth 2.0"));
    }

    private List<SmartConnectorOperationDecorator> buildDecoratedOperations() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Operation operation : this.getOperations()) {
            builder.add((Object)new SmartConnectorOperationDecorator(operation, this.securitySchemesNames));
        }
        return builder.build();
    }

    @Override
    public String getGroupId() {
        return StringUtils.isNotBlank((CharSequence)super.getGroupId()) ? super.getGroupId() : DEFAULT_GROUP_ID;
    }

    @Override
    public String getArtifactId() {
        return StringUtils.isNotBlank((CharSequence)super.getArtifactId()) ? super.getArtifactId() : this.getDefaultArtifactId();
    }

    protected List<SmartConnectorSecuritySchemeDecorator> getOperationsSecuritySchemes() {
        LinkedList<SmartConnectorSecuritySchemeDecorator> operationSchemes = new LinkedList<SmartConnectorSecuritySchemeDecorator>();
        for (SmartConnectorOperationDecorator operation : this.getDecoratedOperations()) {
            if (operation.isUserSelectedSecuritySchemes()) {
                for (SmartConnectorSecuritySchemeDecorator operationSecurityScheme : operation.getAllSecuritySchemes()) {
                    if (!operationSchemes.stream().noneMatch(x -> x.equals(operationSecurityScheme))) continue;
                    operationSchemes.add(operationSecurityScheme);
                }
                continue;
            }
            SmartConnectorSecuritySchemeDecorator operationSecurityScheme = operation.getSecurityScheme();
            if (!operationSchemes.stream().noneMatch(x -> x.equals(operationSecurityScheme))) continue;
            operationSchemes.add(operationSecurityScheme);
        }
        return operationSchemes;
    }

    public SmartConnectorMergedSchemeDecorator buildMergedSecurityScheme() {
        return new SmartConnectorMergedSchemeDecorator(this.getOperationsSecuritySchemes(), this.getModulePrefix());
    }

    public SmartConnectorMergedSchemeDecorator getMergedSecurityScheme() {
        return this.mergedScheme;
    }

    private String getDefaultArtifactId() {
        return DEFAULT_ARTIFACT_PREFIX + this.getModulePrefix();
    }

    public String getModulePrefix() {
        return ParserUtils.removeMavenArtifactUnwantedCharacters(ParserUtils.getXmlName(this.getApiName()));
    }

    public String getNamespace() {
        return "http://www.mulesoft.org/schema/mule/" + this.getModulePrefix();
    }

    public String getBasePath() {
        if (this.getBaseUri() == null) {
            return "/";
        }
        return StringUtils.isBlank((CharSequence)this.getBaseUri().getPath()) ? "/" : this.getBaseUri().getPath();
    }

    public String getProtocol() {
        if (this.getBaseUri() == null) {
            return null;
        }
        return this.getBaseUri().getScheme().toUpperCase();
    }

    public String getHost() {
        if (this.getBaseUri() == null) {
            return null;
        }
        return this.getBaseUri().getHost();
    }

    public Integer getPort() {
        if (this.getBaseUri() == null) {
            return null;
        }
        if (this.getBaseUri().getPort() != -1) {
            return this.getBaseUri().getPort();
        }
        switch (this.getProtocol()) {
            case "HTTP": {
                return 80;
            }
            case "HTTPS": {
                return 443;
            }
        }
        return null;
    }

    public List<SmartConnectorOperationDecorator> getDecoratedOperations() {
        return this.decoratedOperations;
    }

    public String getProjectDescription() {
        String projectDescription = this.model.getProjectDescription();
        String apiDescription = this.model.getApiDescription();
        String finalDescription = "";
        if (StringUtils.isNotBlank((CharSequence)projectDescription) && StringUtils.isNotBlank((CharSequence)apiDescription)) {
            finalDescription = String.format("%s - %s", projectDescription, apiDescription);
        } else if (StringUtils.isNotBlank((CharSequence)projectDescription)) {
            finalDescription = projectDescription;
        } else if (StringUtils.isNotBlank((CharSequence)apiDescription)) {
            finalDescription = apiDescription;
        }
        return StringUtils.abbreviate((String)finalDescription, (int)250);
    }

    public boolean hasOauthScheme() {
        return this.hasOauthScheme;
    }
}

