/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import com.google.common.base.CaseFormat;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ConfigurationUtil;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ConnectionProvider;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ExtensionEntity;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
extends ExtensionEntity {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private final String name;
    private final String basePackage;
    private final String displayName;
    private final List<ConnectionProvider> connectionProviders;
    private final List<Operation> operations;
    private final String xml;

    public Config(RestConnectAPIModel model, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.name = ConfigurationUtil.buildApiName(model);
        this.basePackage = ConfigurationUtil.buildBasePackage(model, this.name);
        this.displayName = this.name;
        this.xml = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name).replace("_", "-");
        this.connectionProviders = model.getOperations().stream().map(org.mule.connectivity.restconnect.internal.model.operation.Operation::getSecuritySchemes).flatMap(Collection::stream).distinct().map(scheme -> new ConnectionProvider(model, (APISecurityScheme)scheme, sourcesPath, resourcesPath, context)).collect(Collectors.toList());
        this.operations = model.getOperations().stream().map(operation -> new Operation((org.mule.connectivity.restconnect.internal.model.operation.Operation)operation, sourcesPath, resourcesPath, context)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<ConnectionProvider> getConnectionProviders() {
        return this.connectionProviders;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public String getXml() {
        return this.xml;
    }

    @Override
    public void generate() {
        this.applyTemplate("templates/sdk/config/Configuration.vm", String.format("internal/config/%sConfiguration.java", this.name));
        this.connectionProviders.forEach(ConnectionProvider::generate);
        this.operations.forEach(Operation::generate);
    }
}

