/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.raml.v2.internal.utils.Inflector;

public class ParserUtils {
    public static final String IGNORE_ANNOTATION = "ignored";
    public static final String DEFAULT_ANNOTATION = "default";
    public static final String USER_SELECTED_SECURITY_SCHEMES_ANNOTATION = "userSelectedSecuritySchemes";
    public static final String PARAMETER_NAME_ANNOTATION = "parameterName";
    public static final String OPERATION_NAME_ANNOTATION = "operationName";
    public static final String PART_NAME_ANNOTATION = "partName";
    public static final String PART_FILENAME_ANNOTATION = "partFilename";
    public static final String PART_CONTENT_TYPE_ANNOTATION = "partContentType";
    public static final String PART_NAME_PARAMETER_ANNOTATION = "partNameParameter";
    public static final String PART_FILENAME_PARAMETER_ANNOTATION = "partFilenameParameter";
    private static final List<String> reservedJavaWords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
    private static final List<String> reservedProcessorParameterNames = Arrays.asList("name", "friendlyName", "operationName");

    protected ParserUtils() {
    }

    public static String removeJavaNameUnwantedCharacters(String name) {
        return ParserUtils.removeJavaNameUnwantedCharacters(name, "j");
    }

    public static String removeJavaNameUnwantedCharacters(String name, String sanitizeSufix) {
        if (name == null) {
            return null;
        }
        String javaName = name.replaceAll("[^a-zA-Z0-9_]", "");
        if (javaName.matches("^[0-9_].*") || !ParserUtils.isValidDevKitParameterName(javaName)) {
            javaName = sanitizeSufix + javaName;
        }
        if (StringUtils.isBlank((CharSequence)javaName)) {
            return "empty";
        }
        return javaName;
    }

    public static String removeJavaPackageUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        String[] split = name.split("[.]");
        StringBuilder packageString = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            packageString.append(ParserUtils.removeJavaNameUnwantedCharacters(split[i]).toLowerCase());
            if (i >= split.length - 1) continue;
            packageString.append(".");
        }
        return packageString.toString();
    }

    public static String removeMavenArtifactUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9_\\-]", "");
    }

    public static String removeMavenGroupUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9\\._\\-]", "");
    }

    public static String removeMavenVersionUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9\\._\\-]", "");
    }

    public static String removeXmlUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9_-]", "");
    }

    public static String getCapUnderscoreName(String name) {
        return ParserUtils.splitCapsWithUnderscores(ParserUtils.getSanitizedOperationName(name)).toUpperCase();
    }

    public static String getSanitizedOperationName(String name) {
        name = name.replaceAll("-", "_");
        if ((name = name.replaceAll("[^a-zA-Z0-9_-]", "")).startsWith("_")) {
            name = name.replaceFirst("_", "");
        }
        return name;
    }

    public static String getXmlName(String name) {
        return ParserUtils.splitCapsWithHypens(ParserUtils.getXmlSanitizedName(name)).toLowerCase();
    }

    public static String splitCapsWithUnderscores(String name) {
        return ParserUtils.splitCaps(name, "_");
    }

    public static String splitCapsWithHypens(String name) {
        return ParserUtils.splitCaps(name, "-");
    }

    public static String splitCaps(String name, String split) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (i + 1 < name.length() && Character.isLowerCase(name.charAt(i)) && Character.isUpperCase(name.charAt(i + 1))) {
                builder.append(name.charAt(i));
                builder.append(split);
                continue;
            }
            if (i + 1 < name.length() && i - 1 >= 0 && Character.isUpperCase(name.charAt(i)) && Character.isLowerCase(name.charAt(i + 1)) && Character.isUpperCase(name.charAt(i - 1))) {
                builder.append(split);
                builder.append(name.charAt(i));
                continue;
            }
            if (i + 1 < name.length() && i > 0 && (name.charAt(i) == '_' || String.valueOf(name.charAt(i)).equals(split)) && Character.isAlphabetic(name.charAt(i + 1))) {
                builder.append(split);
                continue;
            }
            builder.append(name.charAt(i));
        }
        return builder.toString();
    }

    public static String splitNumbersAndLetters(String name, String split) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (i + 1 < name.length() && Character.isAlphabetic(name.charAt(i)) && Character.isDigit(name.charAt(i + 1))) {
                builder.append(name.charAt(i));
                builder.append(split);
                continue;
            }
            if (i + 1 < name.length() && Character.isDigit(name.charAt(i)) && Character.isAlphabetic(name.charAt(i + 1))) {
                builder.append(name.charAt(i));
                builder.append(split);
                continue;
            }
            builder.append(name.charAt(i));
        }
        return builder.toString();
    }

    public static String getXmlSanitizedName(String name) {
        if (StringUtils.isEmpty((CharSequence)(name = ParserUtils.removeXmlUnwantedCharacters(name)))) {
            return "";
        }
        if (name.toLowerCase().startsWith("xml") || Character.isDigit(name.charAt(0))) {
            name = "_" + name;
        }
        if (name.startsWith("-")) {
            name = name.replaceFirst("-", "_");
        }
        return name;
    }

    public static String getJavaName(String operationName) {
        return Inflector.lowercamelcase((String)ParserUtils.removeJavaNameUnwantedCharacters(operationName));
    }

    protected static String getCanonicalNameFromFriendlyName(String friendlyName) {
        friendlyName = friendlyName.replace(" ", "_");
        return ParserUtils.removeXmlUnwantedCharacters(friendlyName.toUpperCase());
    }

    protected static String getParameterName(String uriValue) {
        String cleanParameterName = uriValue.replace("{", "").replace("}", "");
        return Inflector.upperunderscorecase((String)cleanParameterName);
    }

    protected static boolean hasUriParameter(String uriValue) {
        return uriValue.matches("\\{.*\\}");
    }

    public static String removeSpaces(String string) {
        return string == null ? null : string.replace(" ", "");
    }

    public static String removeDots(String string) {
        return string == null ? null : string.replace(".", "");
    }

    public static String removeHyphens(String string) {
        return string == null ? null : string.replace("-", "");
    }

    public static String removeSpacesAndHyphens(String string) {
        return ParserUtils.removeHyphens(ParserUtils.removeSpaces(string));
    }

    public static boolean isReservedJavaWord(String word) {
        return reservedJavaWords.contains(word);
    }

    public static boolean isReservedProcessorVariableName(String word) {
        return reservedProcessorParameterNames.contains(word);
    }

    public static boolean isValidDevKitParameterName(String word) {
        return !ParserUtils.isReservedJavaWord(word) && !ParserUtils.isReservedProcessorVariableName(word);
    }

    protected static String getCanonicalOperationName(HTTPMethod method, String path, String friendlyName, String annotatedName) {
        if (annotatedName != null) {
            return ParserUtils.getCanonicalNameFromFriendlyName(annotatedName);
        }
        if (friendlyName != null) {
            return ParserUtils.getCanonicalNameFromFriendlyName(friendlyName);
        }
        return ParserUtils.buildCanonicalOperationName(method, path);
    }

    private static String replaceOdataParams(String string) {
        Pattern oDataParameterPattern = Pattern.compile("([^\\s\\(\\)\\{\\}\\=\\,]+)\\=\\'\\{([^\\s\\(\\)\\{\\}\\=\\,]+)\\}\\'");
        Matcher oDataParameterMatcher = oDataParameterPattern.matcher(string);
        return oDataParameterMatcher.replaceAll("$1");
    }

    private static String buildCanonicalOperationName(HTTPMethod method, String path) {
        StringBuilder operationNameBuilder = new StringBuilder().append(method.getVerbName());
        String resourceName = null;
        Boolean isElement = null;
        ArrayList<String> parameters = new ArrayList<String>();
        String remainingPath = ParserUtils.replaceOdataParams(path);
        do {
            String pathSegment = remainingPath.substring(remainingPath.lastIndexOf("/") + 1);
            boolean hasParameter = ParserUtils.hasUriParameter(pathSegment);
            if (isElement == null) {
                isElement = hasParameter;
            }
            if (hasParameter) {
                parameters.add(ParserUtils.getCapUnderscoreName(pathSegment));
                continue;
            }
            if (resourceName != null) continue;
            resourceName = pathSegment;
        } while (StringUtils.isNotBlank((CharSequence)(remainingPath = remainingPath.substring(0, remainingPath.lastIndexOf("/")))) && !remainingPath.equals("/"));
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            resourceName = isElement != false || method.isAlwaysSingular() ? Inflector.singularize((String)resourceName) : Inflector.pluralize((String)resourceName);
            operationNameBuilder.append("_").append(ParserUtils.getCapUnderscoreName(resourceName));
        }
        if (!parameters.isEmpty()) {
            Collections.reverse(parameters);
            operationNameBuilder.append("_BY_").append(StringUtils.join(parameters, (String)"_"));
        }
        return operationNameBuilder.toString();
    }
}

