package org.mule.connectivity.restconnect.internal.model.typesource;

import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.PartParameter;

import java.util.List;

public class MultipartTypeSource implements TypeSource {

    private final List<PartParameter> parts;
    private final XmlTypeSource xmlTypeSource;

    public MultipartTypeSource(List<PartParameter> parts, XmlTypeSource xmlTypeSource) {
        this.parts = parts;
        this.xmlTypeSource = xmlTypeSource;
    }

    @Override
    public String getValue() {
        return this.xmlTypeSource.getValue();
    }

    public XmlTypeSource getXmlSource(){
        return this.xmlTypeSource;
    }

    public String getXmlSourceElementName(){
        return xmlTypeSource.getElementName();
    }

    public List<PartParameter> getParts(){
        return this.parts;
    }

}
