package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

import static com.google.common.base.CaseFormat.LOWER_CAMEL;
import static com.google.common.base.CaseFormat.UPPER_CAMEL;
import static java.lang.String.format;
import static org.mule.connectivity.restconnect.internal.util.FileGenerationUtils.writeSchema;

public class Content extends Parameter {
    private final String schemaFile;
    private final String schemaType;

    public Content(String name, TypeDefinition typeDefinition, Path outputDir, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(name, typeDefinition, sourcesPath, resourcesPath, context);
        this.schemaFile = writeSchema(typeDefinition.getSource(), format("%s-schema", name), outputDir);
        this.schemaType = Optional.ofNullable(schemaFile)
                .map(value -> LOWER_CAMEL.to(UPPER_CAMEL, value.substring(value.lastIndexOf(".") + 1)))
                .orElse(null);
    }

    public String getSchemaFile() {
        return schemaFile;
    }

    public String getSchemaType() {
        return schemaType;
    }

    public String getQname() {
        return null;
    }

    @Override
    public String getType() {
        return "InputStream";
    }

    @Override
    public String getName() {
        return format("%sBody", super.getName());
    }
}
