/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import java.nio.file.Path;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.templateEngine.TemplateEngine;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.SdkConnectorTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ConfigurationUtil;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkConnectorTemplateEngine
extends TemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(SdkConnectorTemplateEngine.class);
    private static ToolManager velocityToolManager = new ToolManager();
    private final RestConnectAPIModel model;
    private final Path outputDir;

    public SdkConnectorTemplateEngine(SdkConnectorTemplateEngineBuilder builder) {
        this.model = builder.getModel();
        this.outputDir = builder.getOutputDir();
    }

    @Override
    public void applyTemplates() throws Exception {
        new Extension(this.model, this.outputDir.resolve(String.format("generated-sources/%s", ConfigurationUtil.buildBasePackage(this.model, ConfigurationUtil.buildApiName(this.model)).replaceAll("\\.|_", "/"))), this.outputDir.resolve("generated-resources"), new VelocityContext((Context)velocityToolManager.createContext())).generate();
    }

    static {
        velocityToolManager.configure("velocity-tools.xml");
    }
}

