/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;
import org.mule.connectivity.restconnect.internal.util.JavaRequestUtils;
import org.mule.connectivity.restconnect.internal.util.TemplateUtils;

public abstract class ExtensionEntity {
    private final VelocityContext context;
    private final Path sourcesPath;
    private final Path resourcesPath;

    public ExtensionEntity(Path sourcesPath, Path resourcesPath, VelocityContext context) {
        this.context = context;
        this.sourcesPath = sourcesPath;
        this.resourcesPath = resourcesPath;
    }

    public abstract void generate();

    protected Path getResourcesPath() {
        return this.resourcesPath;
    }

    protected void applyTemplate(String template, String relativePath) {
        this.context.put(this.getClass().getSimpleName().toLowerCase(), (Object)this);
        this.context.put("StringUtils", StringUtils.class);
        this.context.put("DataWeaveUtils", DataWeaveUtils.class);
        this.context.put("JavaRequestUtils", JavaRequestUtils.class);
        this.context.put("TemplateUtils", TemplateUtils.class);
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        File targetFile = this.sourcesPath.resolve(relativePath).toFile();
        targetFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile));){
            engine.getTemplate(template, "UTF-8").merge((Context)this.context, (Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

