/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsonschema2pojo.rules.RuleFactory;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.PojoFQNamePool;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitSecuritySchemeDecoratorFactory;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

public class DevKitOperationDecorator
extends OperationDecorator {
    private final String basePackage;
    private final DevKitConnectorTypeDefinitionDecorator inputMetadata;
    private final DevKitConnectorTypeDefinitionDecorator outputMetadata;
    private final List<DevKitConnectorTypeDefinitionDecorator> queryParameters;
    private final List<DevKitConnectorTypeDefinitionDecorator> uriParameters;
    private final List<DevKitConnectorTypeDefinitionDecorator> parameters;
    private final List<DevKitConnectorTypeDefinitionDecorator> headers;
    private final List<DevKitConnectorTypeDefinitionDecorator> partParameters;
    private final List<DevKitSecuritySchemeDecorator> securitySchemes;
    private final Map<APISecurityScheme, String> securitySchemesNames;
    private final PojoFQNamePool pojoFQNamePool;

    public DevKitOperationDecorator(Operation operation, String basePackage, Map<APISecurityScheme, String> securitySchemesNames, PojoFQNamePool pojoFQNamePool) {
        super(operation);
        this.securitySchemesNames = securitySchemesNames;
        this.pojoFQNamePool = pojoFQNamePool;
        this.basePackage = basePackage;
        this.inputMetadata = this.buildInputMetadata();
        this.outputMetadata = this.buildOutputMetadata();
        this.queryParameters = this.buildDecoratedQueryParameters();
        this.uriParameters = this.buildDecoratedUriParameters();
        this.headers = this.buildDecoratedHeaders();
        this.partParameters = this.buildDecoratedPartParameters();
        this.parameters = this.buildDecoratedParameters();
        this.securitySchemes = this.buildDecoratedSecuritySchemes();
    }

    private DevKitConnectorTypeDefinitionDecorator buildInputMetadata() {
        if (this.getInputMetadata() == null) {
            return null;
        }
        DevKitConnectorTypeDefinitionDecorator inputMetadata = new DevKitConnectorTypeDefinitionDecorator(this.getInputMetadata(), this.basePackage, this.pojoFQNamePool);
        inputMetadata.setClassName(WordUtils.capitalize((String)this.getMethodName()) + "Request");
        return inputMetadata;
    }

    private DevKitConnectorTypeDefinitionDecorator buildOutputMetadata() {
        if (this.getOutputMetadata() == null) {
            return null;
        }
        DevKitConnectorTypeDefinitionDecorator outputMetadata = new DevKitConnectorTypeDefinitionDecorator(this.getOutputMetadata(), this.basePackage, this.pojoFQNamePool);
        outputMetadata.setClassName(WordUtils.capitalize((String)this.getMethodName()) + "Response");
        return outputMetadata;
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedPartParameters() {
        return this.buildParameters(this.getPartParameters());
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedUriParameters() {
        return this.buildParameters(this.getUriParameters());
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedQueryParameters() {
        return this.buildParameters(this.getQueryParameters());
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedHeaders() {
        return this.buildParameters(this.getHeaders());
    }

    private List<DevKitSecuritySchemeDecorator> buildDecoratedSecuritySchemes() {
        return this.operation.getSecuritySchemes().stream().map(x -> DevKitSecuritySchemeDecoratorFactory.getSecuritySchemeDecorator(x, this.securitySchemesNames, this.pojoFQNamePool)).collect(Collectors.toList());
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildParameters(List<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            DevKitConnectorTypeDefinitionDecorator typeDefinitionDecorator = new DevKitConnectorTypeDefinitionDecorator(parameter.getExternalName(), parameter.getInternalName(), parameter.getTypeDefinition(), this.basePackage, this.pojoFQNamePool);
            if (typeDefinitionDecorator.requiresPojo() && StringUtils.isBlank((String)typeDefinitionDecorator.getClassName())) {
                typeDefinitionDecorator.setClassName(WordUtils.capitalize((String)this.getMethodName()) + WordUtils.capitalize((String)parameter.getInternalName()));
            }
            builder.add((Object)typeDefinitionDecorator);
        }
        return builder.build();
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedParameters() {
        return ImmutableList.builder().addAll(this.uriParameters).addAll(this.queryParameters).addAll(this.headers).addAll(this.partParameters).build();
    }

    public String getMethodName() {
        return ParserUtils.getJavaName(this.operation.getCanonicalName());
    }

    public String getTestClassName() {
        return WordUtils.capitalize((String)this.getMethodName()) + "TestCase";
    }

    public String getArguments() {
        ArrayList<String> stream = new ArrayList<String>();
        for (DevKitConnectorTypeDefinitionDecorator parameter : this.getDecoratedParameters()) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((String)parameter.getAnnotatedParameterName())) {
                sb.append("@FriendlyName(\"");
                sb.append(StringEscapeUtils.escapeJava((String)parameter.getAnnotatedParameterName()));
                sb.append("\") ");
            } else if (!ParserUtils.isValidDevKitParameterName(parameter.getInternalName())) {
                sb.append("@FriendlyName(\"");
                sb.append(StringEscapeUtils.escapeJava((String)parameter.getInternalName()));
                sb.append("\") ");
            }
            if (!parameter.isRequired()) {
                sb.append("@Optional ");
            }
            sb.append(this.buildDefaultValueArgumentAnnotation(parameter));
            sb.append(parameter.getClassName());
            sb.append(" ");
            sb.append(parameter.getInternalName());
            sb.append(" ");
            stream.add(sb.toString());
        }
        if (this.operation.getInputMetadata() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("@RefOnly @Default(\"#[payload]\") ");
            sb.append(this.getDecoratedInputMetadata().getClassName());
            sb.append(" entity");
            stream.add(sb.toString());
        }
        return Joiner.on((String)", ").join(stream);
    }

    protected String buildDefaultValueArgumentAnnotation(DevKitConnectorTypeDefinitionDecorator parameter) {
        if (!parameter.hasDefaultValue()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("@Default(\"");
        if (parameter.isEnumType() && !parameter.getClassName().toLowerCase().endsWith("string")) {
            RuleFactory ruleFactory = new RuleFactory();
            String jsonFieldName = ruleFactory.getNameHelper().getFieldName(parameter.getDefaultValue(), null);
            jsonFieldName = ruleFactory.getNameHelper().replaceIllegalCharacters(jsonFieldName);
            jsonFieldName = ruleFactory.getNameHelper().normalizeName(jsonFieldName);
            jsonFieldName = Character.toLowerCase(jsonFieldName.charAt(0)) + jsonFieldName.substring(1);
            String enumJsonFieldName = ParserUtils.splitNumbersAndLetters(ParserUtils.splitCapsWithUnderscores(jsonFieldName), "_").toUpperCase();
            builder.append(enumJsonFieldName);
        } else {
            builder.append(StringEscapeUtils.escapeJava((String)parameter.getDefaultValue()));
        }
        builder.append("\") ");
        return builder.toString();
    }

    public DevKitConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public DevKitConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedQueryParameters() {
        return this.queryParameters;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedUriParameters() {
        return this.uriParameters;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedHeaders() {
        return this.headers;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }

    public List<DevKitSecuritySchemeDecorator> getSecuritySchemes() {
        return this.securitySchemes;
    }

    @Override
    public String getFriendlyName() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)super.getAnnotatedDisplayName())) {
            return StringEscapeUtils.escapeJava((String)super.getAnnotatedDisplayName());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)super.getFriendlyName())) {
            return StringEscapeUtils.escapeJava((String)super.getFriendlyName());
        }
        return null;
    }
}

