package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.Path;
import java.util.List;

import static com.google.common.base.CaseFormat.LOWER_UNDERSCORE;
import static com.google.common.base.CaseFormat.UPPER_CAMEL;
import static java.lang.String.format;
import static java.util.stream.Collectors.toList;

public class Config extends ExtensionEntity {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private final String name;
    private final String basePackage;
    private final String displayName;
    private final List<ConnectionProvider> connectionProviders;
    private final List<Operation> operations;
    private final String xml;

    public Config(RestConnectAPIModel model, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.name = ConfigurationUtil.buildApiName(model);
        this.basePackage = ConfigurationUtil.buildBasePackage(model, name);
        this.displayName = name;
        this.xml = UPPER_CAMEL.to(LOWER_UNDERSCORE, name).replace("_", "-");
        this.connectionProviders = model.getOperations().stream()
                .map(org.mule.connectivity.restconnect.internal.model.operation.Operation::getSecuritySchemes)
                .flatMap(List::stream)
                .distinct()
                .map(scheme -> new ConnectionProvider(model, scheme, sourcesPath, resourcesPath, context))
                .collect(toList());
        this.operations = model.getOperations().stream().map(operation -> new Operation(operation, sourcesPath, resourcesPath, context)).collect(toList());
    }

    public String getName() {
        return name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public List<ConnectionProvider> getConnectionProviders() {
        return connectionProviders;
    }

    public List<Operation> getOperations() {
        return operations;
    }

    public String getXml() {
        return xml;
    }

    @Override
    public void generate() {
        applyTemplate("templates/sdk/config/Configuration.vm", format("internal/config/%sConfiguration.java", name));
        connectionProviders.forEach(ConnectionProvider::generate);
        operations.forEach(Operation::generate);
    }
}
