/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import com.google.googlejavaformat.java.Formatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.templateEngine.TemplateEngine;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.DevKitTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.DevKitConnectorModelDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.DevKitOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitBasicAuthSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitCustomAuthenticationSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitOAuth2AuthorizationCodeSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitOAuth2ClientCredentialsSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitPassThroughSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevKitTemplateEngine
extends TemplateEngine {
    private static final String CONNECTOR = "connector";
    private static final String OPERATION = "operation";
    private static final String BASE_URI = "baseUri";
    private static final String SECURITY_SCHEME = "securityScheme";
    private static final String SUPPORTS_BASIC_AUTH = "SUPPORTS_BASIC_AUTH";
    private static final String SUPPORTS_PASS_THROUGH = "SUPPORTS_PASS_THROUGH";
    private static final String SUPPORTS_CUSTOM_AUTHENTICATION = "SUPPORTS_CUSTOM_AUTHENTICATION";
    private static final String SUPPORTS_OAUTH2 = "SUPPORTS_OAUTH2";
    private static final String SUPPORTS_OAUTH2_CLIENT_CREDENTIALS = "SUPPORTS_OAUTH2_CLIENT_CREDENTIALS";
    private static final String SUPPORTS_OAUTH2_AUTHORIZATION_CODE = "SUPPORTS_OAUTH2_AUTHORIZATION_CODE";
    private static final String CONNECTOR_TEMPLATE_VM = "templates/devkit/ConnectorTemplate.vm";
    private static final String REST_CLIENT_CONFIG_PROVIDER_VM = "templates/devkit/RestClientConfigProvider.vm";
    private static final String ABSTRACT_CONFIG_VM = "templates/devkit/AbstractConfig.vm";
    private static final String POM_VM = "templates/devkit/pom.vm";
    private static final String LICENSE_MD_VM = "templates/devkit/LICENSE.md";
    private static final Path MAIN_DIR = Paths.get("src/main/java/", new String[0]);
    private final DevKitConnectorModelDecorator model;
    private final Path outputDir;
    private final boolean generateProjectFiles;
    private final Logger logger = LoggerFactory.getLogger(DevKitTemplateEngine.class);

    public DevKitTemplateEngine(DevKitTemplateEngineBuilder builder) {
        this.model = new DevKitConnectorModelDecorator(builder.getModel());
        this.generateProjectFiles = builder.getProjectFilesGeneration();
        this.outputDir = builder.getOutputDir();
    }

    @Override
    public void applyTemplates() throws Exception {
        this.createPojos();
        this.createConnector();
    }

    private void createPojos() {
        Path output = this.outputDir.resolve(MAIN_DIR);
        output.toFile().mkdirs();
        for (DevKitOperationDecorator operation : this.model.getDecoratedOperations()) {
            try {
                if (operation.getDecoratedInputMetadata() != null && operation.getDecoratedInputMetadata().requiresPojo()) {
                    operation.getDecoratedInputMetadata().generatePojo(output);
                }
            }
            catch (GenerationException e) {
                operation.getDecoratedInputMetadata().setFailedToGeneratePojo(true);
                this.logger.error(String.format("Error while creating POJO for input metadata at %s operation", operation.getMethodName()), (Throwable)e);
            }
            try {
                if (operation.getDecoratedOutputMetadata() != null && operation.getDecoratedOutputMetadata().requiresPojo()) {
                    operation.getDecoratedOutputMetadata().generatePojo(output);
                }
            }
            catch (GenerationException e) {
                operation.getDecoratedOutputMetadata().setFailedToGeneratePojo(true);
                this.logger.error(String.format("Error while creating POJO for output metadata at %s operation", operation.getMethodName()), (Throwable)e);
            }
            for (DevKitConnectorTypeDefinitionDecorator parameter : operation.getDecoratedParameters()) {
                try {
                    if (!parameter.requiresPojo()) continue;
                    parameter.generatePojo(output);
                }
                catch (GenerationException e) {
                    parameter.setFailedToGeneratePojo(true);
                    this.logger.error(String.format("Error while creating POJO for parameter %s at %s operation", parameter.getExternalName(), operation.getMethodName()), (Throwable)e);
                }
            }
        }
    }

    private void createConnector() throws Exception {
        VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
        context.internalPut(CONNECTOR, (Object)this.model);
        if (this.model.getBaseUri() != null) {
            context.internalPut(BASE_URI, (Object)this.model.getBaseUriAsString());
        }
        Path outputBaseDir = this.outputDir;
        Path packagePath = Paths.get(this.model.getBasePackage().replace('.', File.separatorChar), new String[0]);
        Path mainDir = outputBaseDir.resolve(MAIN_DIR).resolve(packagePath);
        for (DevKitSecuritySchemeDecorator securityScheme : this.model.getSecuritySchemes()) {
            if (securityScheme instanceof DevKitBasicAuthSchemeDecorator) {
                context.internalPut(SUPPORTS_BASIC_AUTH, (Object)true);
            }
            if (securityScheme instanceof DevKitOAuth2ClientCredentialsSchemeDecorator) {
                context.internalPut(SUPPORTS_OAUTH2, (Object)true);
                context.internalPut(SUPPORTS_OAUTH2_CLIENT_CREDENTIALS, (Object)true);
            }
            if (securityScheme instanceof DevKitOAuth2AuthorizationCodeSchemeDecorator) {
                context.internalPut(SUPPORTS_OAUTH2, (Object)true);
                context.internalPut(SUPPORTS_OAUTH2_AUTHORIZATION_CODE, (Object)true);
            }
            if (securityScheme instanceof DevKitPassThroughSchemeDecorator) {
                context.internalPut(SUPPORTS_PASS_THROUGH, (Object)true);
            }
            if (securityScheme instanceof DevKitCustomAuthenticationSchemeDecorator) {
                context.internalPut(SUPPORTS_CUSTOM_AUTHENTICATION, (Object)true);
            }
            if (securityScheme instanceof DevKitOAuth2AuthorizationCodeSchemeDecorator && StringUtils.isNotBlank((CharSequence)securityScheme.getConfigNameSufix())) continue;
            context.internalPut(SECURITY_SCHEME, (Object)securityScheme);
            this.applyTemplate(securityScheme.getTemplateLocation(), mainDir.resolve(securityScheme.getConfigName() + ".java"), context);
            context.internalRemove((Object)SECURITY_SCHEME);
        }
        if (!context.internalContainsKey((Object)SUPPORTS_BASIC_AUTH) && context.internalContainsKey((Object)SUPPORTS_OAUTH2) && !context.internalContainsKey((Object)SUPPORTS_OAUTH2_CLIENT_CREDENTIALS) && !context.internalContainsKey((Object)SUPPORTS_OAUTH2_AUTHORIZATION_CODE)) {
            String grants = this.getGrants(this.model.getSecuritySchemes().stream().map(DevKitSecuritySchemeDecorator::getApiSecurityScheme).collect(Collectors.toList()));
            throw new UnsupportedSecuritySchemeException("OAuth 2.0 grant types supported are Client Credentials and Authorization Code ( " + grants + " not supported )");
        }
        this.applyTemplate(CONNECTOR_TEMPLATE_VM, mainDir.resolve(this.model.getClassName() + ".java"), context);
        this.applyTemplate(ABSTRACT_CONFIG_VM, mainDir.resolve("AbstractConfig.java"), context);
        this.applyTemplate(REST_CLIENT_CONFIG_PROVIDER_VM, mainDir.resolve("RestClientConfigProvider.java"), context);
        this.applyTemplate(LICENSE_MD_VM, outputBaseDir.resolve("LICENSE.md"), context);
        if (this.generateProjectFiles) {
            Path pomPath = outputBaseDir.resolve("pom.xml");
            this.applyTemplate(POM_VM, pomPath, context);
            this.checkPomIsConsistent(pomPath);
        }
    }

    @Override
    protected Path applyTemplate(String templateVm, Path output, VelocityContext context) throws Exception {
        Path path = super.applyTemplate(templateVm, output, context);
        if (output.toString().endsWith(".java")) {
            this.javaFormat(output);
        }
        return path;
    }

    private void javaFormat(Path filepath) throws IOException {
        String formattedSource;
        try {
            File file = filepath.toFile();
            String content = new String(Files.readAllBytes(filepath), "UTF-8");
            formattedSource = new Formatter().formatSource(content);
            file.delete();
        }
        catch (Exception e) {
            this.logger.error("Could not format file " + filepath.toString(), (Throwable)e);
            return;
        }
        Files.write(filepath, formattedSource.getBytes("UTF-8"), new OpenOption[0]);
    }

    private String getGrants(List<APISecurityScheme> schemas) {
        ArrayList<String> grants = new ArrayList<String>();
        for (APISecurityScheme schema : schemas) {
            if (!(schema instanceof OAuth2Scheme)) continue;
            grants.addAll(((OAuth2Scheme)schema).getAuthorizationGrants());
        }
        return StringUtils.join(grants, (String)", ");
    }
}

