/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import com.google.common.base.CaseFormat;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.WordUtils;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ExtensionEntity;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Parameter;

public class ConnectionProvider
extends ExtensionEntity {
    private final String name;
    private final String extensionName;
    private final String displayName;
    private final String xml;
    private final String endpointUrl;
    private final Map<String, Parameter> headers;
    private final Map<String, Parameter> parameters;
    private final Map<String, Parameter> requestParameters;

    public ConnectionProvider(RestConnectAPIModel model, APISecurityScheme scheme, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.extensionName = WordUtils.capitalizeFully((String)ParserUtils.getXmlName(model.getApiName()).replace("-connector", ""));
        this.name = scheme.getSchemeName().replace(" ", "").replace(".", "");
        this.displayName = scheme.getSchemeName();
        this.xml = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.displayName.toLowerCase().replace(" ", "-").replace(".", ""));
        this.endpointUrl = model.getBaseUri() != null ? model.getBaseUri().toString() : "baseuri.com";
        this.headers = scheme.getHeaders().stream().map(parameter -> new Parameter(parameter.getInternalName(), parameter.getTypeDefinition(), sourcesPath, resourcesPath, context)).collect(Collectors.toMap(Parameter::getName, Function.identity()));
        this.parameters = scheme.getConfigParameters().stream().map(parameter -> new Parameter(parameter.getInternalName(), parameter.getTypeDefinition(), sourcesPath, resourcesPath, context)).collect(Collectors.toMap(Parameter::getName, Function.identity()));
        this.requestParameters = scheme.getQueryParameters().stream().map(parameter -> new Parameter(parameter.getInternalName(), parameter.getTypeDefinition(), sourcesPath, resourcesPath, context)).collect(Collectors.toMap(Parameter::getName, Function.identity()));
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getXml() {
        return this.xml;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public Map<String, Parameter> getHeaders() {
        return this.headers;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Map<String, Parameter> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public void generate() {
        this.applyTemplate(String.format("templates/sdk/connection/provider/%sConnectionProvider.vm", this.name), String.format("internal/connection/provider/%sConnectionProvider.java", this.name));
        if (this.name.equalsIgnoreCase("Jwt")) {
            this.applyTemplate("templates/sdk/connection/provider/param/jwt/AccessTokenRequestParameterGroup.vm", String.format("internal/connection/provider/param/jwt/%sAccessTokenRequestParameterGroup.java", this.extensionName));
            this.applyTemplate("templates/sdk/connection/provider/param/jwt/JwtClaimsParameterGroup.vm", String.format("internal/connection/provider/param/jwt/%sJwtClaimsParameterGroup.java", this.extensionName));
            this.applyTemplate("templates/sdk/connection/provider/param/jwt/JwtHeadersParameterGroup.vm", String.format("internal/connection/provider/param/jwt/%sJwtHeadersParameterGroup.java", this.extensionName));
        }
        this.headers.values().stream().forEach(Parameter::generate);
        this.parameters.values().stream().forEach(Parameter::generate);
    }
}

