/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader;

import amf.client.remote.Content;
import amf.client.resource.BaseHttpResourceLoader;
import amf.core.remote.UnexpectedStatusCode;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.codehaus.plexus.util.IOUtil;
import scala.Option;

public class SafeProxyResourceLoader
extends BaseHttpResourceLoader {
    private static final String USER_AGENT = "rest-connect";
    private final String proxyBaseUri;
    private final String referer;

    public SafeProxyResourceLoader(String proxyBaseUri, String referer) {
        this.proxyBaseUri = proxyBaseUri.endsWith("/") ? proxyBaseUri.substring(0, proxyBaseUri.length() - 1) : proxyBaseUri;
        this.referer = referer;
    }

    public CompletableFuture<Content> fetch(String resource) {
        if (resource == null || resource.isEmpty()) {
            return this.fail();
        }
        CompletableFuture<Content> f = new CompletableFuture<Content>();
        CompletableFuture.runAsync(() -> {
            try {
                URL u = new URL(String.format("%s/%s", this.proxyBaseUri, resource));
                HttpURLConnection connection = (HttpURLConnection)u.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(60000);
                connection.setRequestProperty("User-Agent", USER_AGENT);
                connection.setRequestProperty("Referer", this.referer);
                Content content = this.createContent(connection);
                f.complete(content);
            }
            catch (Exception e) {
                f.completeExceptionally(e);
            }
            f.completeExceptionally(new Exception("Could not complete future"));
        });
        return f;
    }

    private Content createContent(HttpURLConnection connection) throws Exception {
        connection.connect();
        int statusCode = connection.getResponseCode();
        if (statusCode == 200) {
            Option option = Option.apply((Object)connection.getHeaderField("Content-Type"));
            return new Content(IOUtil.toString((InputStream)connection.getInputStream()), connection.getURL().toString(), option);
        }
        throw new UnexpectedStatusCode(connection.getURL().toString(), statusCode);
    }

    private CompletableFuture<Content> fail() {
        return CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException("Failed to apply.");
        });
    }
}

