package org.mule.connectivity.restconnect.internal.modelGeneration.common.security;

import java.util.LinkedList;
import java.util.List;

public class SecuritySchemeFactory {

    public static <T extends Object> List<T> getSecuritySchemesForOperation(List<T> operationSchemes, List<T> endPointSchemes, List<T> globalSchemes) {

        //If the method defines security, we validate it is supported and create the schemes
        if(!operationSchemes.isEmpty()){
            return operationSchemes;
        }

        //If the method does not defines security, we try with the endpoint
        else if(!endPointSchemes.isEmpty()){
            return endPointSchemes;
        }

        //If the endpoint does not defines security, we try with the global config
        else if(!globalSchemes.isEmpty()){
            return globalSchemes;
        }

        // If the method is not secured we return an empty list.
        else{
            return new LinkedList<T>();
        }
    }

}
