package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.ModelDecorator;

import java.util.List;

public abstract class OperationDecorator {

    protected final Operation operation;
    protected final ModelDecorator modelDecorator;

    public OperationDecorator(Operation operation, ModelDecorator modelDecorator) {
        this.operation = operation;
        this.modelDecorator = modelDecorator;
    }

    public TypeDefinition getInputMetadata() {
        return this.operation.getInputMetadata();
    }

    public TypeDefinition getOutputMetadata() {
        return this.operation.getOutputMetadata();
    }

    public List<Parameter> getQueryParameters() {
        return this.operation.getQueryParameters();
    }

    public List<Parameter> getUriParameters() {
        return this.operation.getUriParameters();
    }

    public List<Parameter> getPartParameters() {
        return this.operation.getPartParameters();
    }

    public List<Parameter> getHeaders() {
        return this.operation.getHeaders();
    }

    public List<Parameter> getParameters() {
        return this.operation.getParameters();
    }

    public boolean hasQueryParameters() {
        return !this.getQueryParameters().isEmpty();
    }

    public boolean hasUriParameters() {
        return !this.getUriParameters().isEmpty();
    }

    public boolean hasHeaders() {
        return !this.getHeaders().isEmpty();
    }

    public String getCanonicalName() {
        return operation.getCanonicalName();
    }

    public String getFriendlyName() {
        return operation.getFriendlyName();
    }

    public String getAnnotatedDisplayName() {
        return operation.getAnnotatedDisplayName();
    }

    public String getHttpMethod() {
        return operation.getHttpMethod();
    }

    public String getUri() {
        return operation.getUri();
    }
}
