package org.mule.connectivity.restconnect.api;

public enum SpecFormat {

    RAML("RAML"),
    JSON_OAS("JsonOAS"),
    YAML_OAS("YamlOAS"),
    JSON_OAS3("YamlOAS3"),
    YAML_OAS3("YamlOAS3");

    private String name;

    SpecFormat(String name){
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SpecFormat getFromString(String specName){
        if(specName.equalsIgnoreCase(RAML.name)){
            return RAML;
        }
        else if(specName.equalsIgnoreCase(JSON_OAS.name)){
            return JSON_OAS;
        }
        else if(specName.equalsIgnoreCase(YAML_OAS.name)){
            return YAML_OAS;
        }

        throw new IllegalArgumentException("Spec format " + specName + " does not exist. (RAML, JsonOAS & YamlOAS available)");
    }

}
