package org.mule.connectivity.restconnect.mojo;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.RestConnect;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

import static org.mule.connectivity.restconnect.internal.util.MojoUtils.getMainRamlFile;


@Mojo(name = "raml2connector", defaultPhase = LifecyclePhase.GENERATE_SOURCES, requiresProject = false)
public class Raml2ConnectorMojo extends AbstractMojo {

    private Logger logger = LoggerFactory.getLogger(Raml2ConnectorMojo.class);

    @Parameter(property = "raml", required = true)
    private String raml;

    @Parameter(property = "name")
    private String name;

    @Parameter(property = "outputDir", defaultValue = "target")
    private File outputDir;

    @Parameter(property = "category", defaultValue = "COMMUNITY")
    private String category;

    @Parameter(defaultValue = "${project}", readonly = true)
    private MavenProject project;

    @Parameter(property = "specFormat", defaultValue = "raml")
    private String specFormat;

    @Parameter(property = "parser", defaultValue = "AMF")
    private String parser;

    public void execute() throws MojoExecutionException {
        try {

            RestConnect.getInstance()
                    .createConnectorFromSpec(getMainRamlFile(raml), SpecFormat.getFromString(specFormat), Parser.getFromString(parser), ConnectorType.DevKitConnector)
                    .withApiName(name)
                    .withCategory(category)
                    .withOutputDir(outputDir.toPath())
                    .withGenerateProjectFiles(generateProjectfiles())
                    .run();

        } catch (Exception e) {
            logger.error("Failed to build connector.", e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }

    // Just generate project files when run without a project.
    private boolean generateProjectfiles() {
        return project.getBasedir() == null;
    }

}