/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader;

import amf.client.resource.FileResourceLoader;
import java.io.File;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeFileResourceLoader
extends FileResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeFileResourceLoader.class);
    private Path rootDir;

    public SafeFileResourceLoader(String rootDir) {
        String basePath = rootDir != null ? rootDir : ".";
        basePath = basePath.startsWith("file://") ? basePath.substring(7) : basePath;
        this.rootDir = new File(basePath.replace("%20", " ")).toPath();
    }

    public boolean accepts(String resource) {
        try {
            if (super.accepts(resource)) {
                String src = resource.startsWith("file://") ? resource.substring(7) : resource;
                src = src.replace("%20", " ");
                Path path = new File(src).getCanonicalFile().toPath();
                return path.startsWith(this.rootDir);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error evaluating resource", (Throwable)e);
            return false;
        }
        return false;
    }
}

