/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;
import org.mule.connectivity.restconnect.internal.util.JavaRequestUtils;

public abstract class TemplateEngine {
    protected static ToolManager velocityToolManager = new ToolManager();

    public abstract void applyTemplates() throws Exception;

    protected Path applyTemplate(String templateVm, Path output, VelocityContext context) throws Exception {
        output.getParent().toFile().mkdirs();
        context.put("StringUtils", StringUtils.class);
        context.put("DataWeaveUtils", DataWeaveUtils.class);
        context.put("JavaRequestUtils", JavaRequestUtils.class);
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output.toFile()));){
            Template template = ve.getTemplate(templateVm, "UTF-8");
            template.merge((Context)context, (Writer)writer);
        }
        return output;
    }

    protected void checkPomIsConsistent(Path pomPath) throws GenerationException {
        try {
            byte[] encoded = Files.readAllBytes(pomPath);
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            pomReader.read((InputStream)new ByteArrayInputStream(encoded));
        }
        catch (Exception e) {
            throw new GenerationException("Error while checking pom consistency", e);
        }
    }

    static {
        velocityToolManager.configure("velocity-tools.xml");
    }
}

