/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.util;

import java.io.File;
import net.lingala.zip4j.exception.ZipException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.internal.util.FileUtils;

public class MojoUtils {
    private MojoUtils() {
    }

    public static File getMainRamlFile(String ramlFileName) {
        File raml = new File(ramlFileName);
        if (raml.getName().toLowerCase().endsWith(".zip")) {
            try {
                File tempDir = FileUtils.unzipFile(raml);
                raml = MojoUtils.getRamlFile(tempDir);
            }
            catch (ZipException e) {
                throw new InvalidSourceException("Invalid zip file.", (Exception)((Object)e));
            }
        }
        return raml.getAbsoluteFile();
    }

    private static File getRamlFile(File dir) {
        File[] ramlFiles = dir.listFiles((dir1, name) -> name.toLowerCase().endsWith(".raml"));
        if (ramlFiles.length == 0) {
            throw new InvalidSourceException("The provided zip file doesn't contain any RAML files.");
        }
        if (ramlFiles.length > 1) {
            throw new InvalidSourceException("The provided zip file contains more than one RAML file.");
        }
        return ramlFiles[0];
    }
}

