package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security;

import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.naming.RAMLSecuritySchemes;

public class RamlParserSecuritySchemesNaming {

    public static boolean isOauth1(String name){
        return RAMLSecuritySchemes.OAUTH1.equalsIgnoreCase(name);
    }

    public static boolean isOauth2(String name){
        return RAMLSecuritySchemes.OAUTH2.equalsIgnoreCase(name);
    }

    public static boolean isPassThrough(String name){
        return RAMLSecuritySchemes.PASS_THROUGH.equalsIgnoreCase(name);
    }

    public static boolean isBasicAuth(String name){
        return RAMLSecuritySchemes.BASIC.equalsIgnoreCase(name);
    }

    public static boolean isDigestAuth(String name){
        return RAMLSecuritySchemes.DIGEST_AUTHENTICATION.equalsIgnoreCase(name);
    }

    public static boolean isJwtAuth(String name) {
        return APISecurityScheme.JWT.equalsIgnoreCase(name) || APISecurityScheme.CUSTOM_JWT.equalsIgnoreCase(name);
    }

    public static boolean isCustom(String name){
        return !RAMLSecuritySchemes.BASIC.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.OAUTH1.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.OAUTH2.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.PASS_THROUGH.equalsIgnoreCase(name) &&
                !RAMLSecuritySchemes.DIGEST_AUTHENTICATION.equalsIgnoreCase(name) &&
                !RamlParserSecuritySchemesNaming.isJwtAuth(name);
    }
}
