/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.XmlTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.PrimitiveMetadataModelFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.HasBodyPredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.IsSupportedTypePredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.predicate.OkResponsePredicate;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class RamlParserTypeDefinitionFactory {
    private static final Predicate<Response> okAndBodyPredicate = Predicates.and((Predicate)new OkResponsePredicate(), (Predicate)new HasBodyPredicate());
    private static final Logger logger = LogManager.getLogger(RamlParserTypeDefinitionFactory.class);
    private final Method method;
    private final JsonSchemaPool jsonSchemaPool;

    public RamlParserTypeDefinitionFactory(Method method, JsonSchemaPool jsonSchemaPool) {
        this.jsonSchemaPool = jsonSchemaPool;
        this.method = method;
    }

    public TypeDefinition constructInputMetadata() throws Exception {
        return this.getTypeDefinitionWithMediaType(this.method.body());
    }

    public TypeDefinition constructOutputMetadata() throws Exception {
        ArrayList<TypeDeclaration> mediaTypes = new ArrayList<TypeDeclaration>();
        for (Response response : Iterables.filter((Iterable)this.method.responses(), okAndBodyPredicate)) {
            mediaTypes.addAll(Collections2.filter((Collection)response.body(), (Predicate)new IsSupportedTypePredicate()));
        }
        return this.getTypeDefinitionWithMediaType(mediaTypes);
    }

    private TypeDefinition getTypeDefinitionWithMediaType(List<TypeDeclaration> typeDeclarations) throws Exception {
        Collection<TypeDeclaration> supportedTypeDeclarations = this.getTypeDeclarations(typeDeclarations);
        if (supportedTypeDeclarations == null) {
            return null;
        }
        Optional<TypeDeclaration> defaultTypeDeclaration = supportedTypeDeclarations.stream().filter(x -> RamlParserUtils.isDefault(x)).findFirst();
        TypeDeclaration typeDeclaration = defaultTypeDeclaration.orElseGet(() -> (TypeDeclaration)supportedTypeDeclarations.iterator().next());
        return RamlParserTypeDefinitionFactory.getTypeDefinition(typeDeclaration, typeDeclaration.name(), this.jsonSchemaPool);
    }

    public static TypeDefinition getTypeDefinition(TypeDeclaration typeDeclaration, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserTypeDefinitionFactory.getTypeDefinition(typeDeclaration, null, jsonSchemaPool);
    }

    public static TypeDefinition getTypeDefinition(TypeDeclaration typeDeclaration, String mediaType, JsonSchemaPool jsonSchemaPool) throws Exception {
        if ("multipart/form-data".equalsIgnoreCase(mediaType)) {
            ObjectTypeDeclaration objTypeDeclaration;
            if (typeDeclaration instanceof ObjectTypeDeclaration && (objTypeDeclaration = (ObjectTypeDeclaration)typeDeclaration).properties().size() > 0) {
                return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new MultipartTypeSource(RamlParserUtils.getPartParameterList(objTypeDeclaration.properties(), new JsonSchemaPool()), new XmlTypeSource(objTypeDeclaration.toXmlSchema())));
            }
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
        if (RamlParserTypeDefinitionFactory.typeIsDefinedWithRAML(typeDeclaration)) {
            return RamlParserTypeDefinitionFactory.safelyGetTypeDefinitionFromRAMLType(typeDeclaration, mediaType, jsonSchemaPool);
        }
        if (RamlParserTypeDefinitionFactory.typeIsDefinedWithXMLSchema(typeDeclaration)) {
            XMLTypeDeclaration xmlTypeDeclaration = (XMLTypeDeclaration)typeDeclaration;
            String elementName = StringUtils.isNotBlank((String)xmlTypeDeclaration.internalFragment()) ? xmlTypeDeclaration.internalFragment() : null;
            XmlTypeSource source = new XmlTypeSource(xmlTypeDeclaration.schemaContent(), elementName, xmlTypeDeclaration.schemaPath());
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, (TypeDeclaration)xmlTypeDeclaration, source);
        }
        if (RamlParserTypeDefinitionFactory.typeIsDefinedWithJSONSchema(typeDeclaration)) {
            JSONTypeDeclaration jsonTypeDeclaration = (JSONTypeDeclaration)typeDeclaration;
            String schemaContent = jsonTypeDeclaration.schemaContent();
            if (StringUtils.isNotBlank((String)schemaContent)) {
                if (jsonSchemaPool.containsSchema(schemaContent)) {
                    return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
                }
                JsonTypeSource source = new JsonTypeSource(jsonTypeDeclaration.schemaContent());
                TypeDefinition newType = RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, (TypeDeclaration)jsonTypeDeclaration, source);
                jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent, newType);
                return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
            }
            JsonTypeSource source = new JsonTypeSource(jsonTypeDeclaration.schemaContent());
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, (TypeDeclaration)jsonTypeDeclaration, source);
        }
        if (RamlParserTypeDefinitionFactory.typeIsEnum(typeDeclaration)) {
            String schemaContent = typeDeclaration.toJsonSchema();
            if (StringUtils.isNotBlank((String)schemaContent)) {
                if (jsonSchemaPool.containsSchema(schemaContent)) {
                    return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
                }
                JsonTypeSource source = new JsonTypeSource(typeDeclaration.toJsonSchema());
                TypeDefinition newType = RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, source);
                jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent, newType);
                return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
            }
            JsonTypeSource source = new JsonTypeSource(typeDeclaration.toJsonSchema());
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, source);
        }
        if (RamlParserTypeDefinitionFactory.typeIsPrimitive(typeDeclaration)) {
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, PrimitiveMetadataModelFactory.createPrimitiveMetadataModel(typeDeclaration));
        }
        if (RamlParserTypeDefinitionFactory.typeDefinitionIsNotProvided(typeDeclaration)) {
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
        logger.warn("Type {} cannot be parsed.", (Object)typeDeclaration.type());
        return null;
    }

    private static TypeDefinition buildTypeDefinition(String mediaType, TypeDeclaration typeDeclaration, TypeSource source) {
        List enumValues = null;
        if (typeDeclaration instanceof StringTypeDeclaration) {
            enumValues = ((StringTypeDeclaration)typeDeclaration).enumValues();
        }
        return new TypeDefinitionBuilder(mediaType == null ? null : MediaType.valueOf((String)mediaType), source, typeDeclaration.required(), typeDeclaration instanceof ArrayTypeDeclaration, typeDeclaration instanceof UnionTypeDeclaration).withDescription(typeDeclaration.description() == null ? null : org.apache.commons.lang3.StringUtils.trimToNull((String)typeDeclaration.description().value())).withDefaultValue(RamlParserTypeDefinitionFactory.getTypeDeclarationDefaultValue(typeDeclaration)).withExample(typeDeclaration.example() == null ? null : typeDeclaration.example().value()).withAnnotatedDisplayName(RamlParserUtils.getAnnotatedParameterName(typeDeclaration)).withEnumValues(enumValues).build();
    }

    private static String getTypeDeclarationDefaultValue(TypeDeclaration typeDeclaration) {
        String defaultValue = "array".equals(typeDeclaration.type()) ? RamlParserTypeDefinitionFactory.cleanupValueStr(typeDeclaration.defaultValue()) : typeDeclaration.defaultValue();
        return StringUtils.isNotBlank((String)defaultValue) ? defaultValue : null;
    }

    private static String cleanupValueStr(String defaultValue) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)defaultValue) ? null : defaultValue.replaceAll("[\\[\\]\n\"]", "");
    }

    private static TypeDefinition safelyGetTypeDefinitionFromRAMLType(TypeDeclaration typeDeclaration, String mediaType, JsonSchemaPool jsonSchemaPool) throws Exception {
        try {
            String schemaContent = typeDeclaration.toJsonSchema();
            if (StringUtils.isNotBlank((String)schemaContent)) {
                if (jsonSchemaPool.containsSchema(schemaContent)) {
                    return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
                }
                TypeDefinition newType = RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new JsonTypeSource(typeDeclaration.toJsonSchema()));
                jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent, newType);
                return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
            }
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new JsonTypeSource(typeDeclaration.toJsonSchema()));
        }
        catch (RuntimeException exception) {
            logger.warn("Couldn't generate a type definition for " + typeDeclaration.name(), (Throwable)exception);
            return RamlParserTypeDefinitionFactory.buildTypeDefinition(mediaType, typeDeclaration, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
    }

    private Collection<TypeDeclaration> getTypeDeclarations(List<TypeDeclaration> typeDeclarations) {
        if (typeDeclarations == null) {
            return null;
        }
        Collection supportedTypeDeclarations = Collections2.filter(typeDeclarations, (Predicate)new IsSupportedTypePredicate());
        if (supportedTypeDeclarations.isEmpty()) {
            return null;
        }
        if (supportedTypeDeclarations.size() > 1) {
            logger.warn("Operation {} {} contains more than one media type. Found: {} media types. Will use the first one.", (Object)this.method.resource().resourcePath(), (Object)this.method.method(), (Object)typeDeclarations.size());
        }
        return supportedTypeDeclarations;
    }

    public static boolean typeIsDefinedWithRAML(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof ObjectTypeDeclaration || typeDeclaration instanceof ArrayTypeDeclaration || typeDeclaration instanceof UnionTypeDeclaration;
    }

    public static boolean typeIsDefinedWithXMLSchema(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof XMLTypeDeclaration;
    }

    public static boolean typeIsDefinedWithJSONSchema(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof JSONTypeDeclaration;
    }

    public static boolean typeIsPrimitive(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof BooleanTypeDeclaration || typeDeclaration instanceof DateTimeOnlyTypeDeclaration || typeDeclaration instanceof DateTypeDeclaration || typeDeclaration instanceof DateTimeTypeDeclaration || typeDeclaration instanceof FileTypeDeclaration || typeDeclaration instanceof IntegerTypeDeclaration || typeDeclaration instanceof NumberTypeDeclaration || typeDeclaration instanceof StringTypeDeclaration || typeDeclaration instanceof TimeOnlyTypeDeclaration;
    }

    public static boolean typeIsEnum(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof StringTypeDeclaration && ((StringTypeDeclaration)typeDeclaration).enumValues() != null && ((StringTypeDeclaration)typeDeclaration).enumValues().size() > 0;
    }

    public static boolean typeDefinitionIsNotProvided(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof AnyTypeDeclaration;
    }
}

