package org.mule.connectivity.restconnect.internal.model.operation;

import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;

import java.util.LinkedList;
import java.util.List;


public class Operation {

    private String friendlyName;
    private String annotatedDisplayName;
    private String description;
    private String canonicalName;
    private List<Parameter> uriParameters;
    private List<Parameter> queryParameters;
    private List<Parameter> headers;
    private List<Parameter> parameters;
    private TypeDefinition inputMetadata;
    private TypeDefinition outputMetadata;
    private HTTPMethod httpMethod;
    private String uri;
    private List<APISecurityScheme> securitySchemes;
    private boolean userSelectedSecuritySchemes;

    Operation() {
        uriParameters = new LinkedList<>();
        queryParameters = new LinkedList<>();
        headers = new LinkedList<>();
        parameters = new LinkedList<>();
    }

    public List<Parameter> getQueryParameters() {
        return queryParameters;
    }

    public List<Parameter> getUriParameters() {
        return uriParameters;
    }

    public List<Parameter> getHeaders() {
        return headers;
    }

    public List<Parameter> getPartParameters() {
        List<Parameter> partParameters = new LinkedList<>();
        if (inputMetadata != null && inputMetadata.getSource() instanceof MultipartTypeSource){
            for (PartParameter part : ((MultipartTypeSource) inputMetadata.getSource()).getParts()) {
                if(part.getPartNameParameter() != null){
                    partParameters.add(part.getPartNameParameter());
                }
                if(part.getPartFilenameParameter() != null){
                    partParameters.add(part.getPartFilenameParameter());
                }
            }
        }
        return partParameters;
    }

    public String getHttpMethod() {
        return httpMethod.toString().toLowerCase();
    }

    public String getUri() {
        return uri;
    }

    public List<Parameter> getParameters() {
        return parameters;
    }

    public String getFriendlyName() {
        return friendlyName;
    }

    public String getDescription() {
        return description;
    }

    public String getCanonicalName() {
        return canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public TypeDefinition getInputMetadata() {
        return inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return outputMetadata;
    }

    public String getAnnotatedDisplayName() {
        return annotatedDisplayName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setAnnotatedDisplayName(String annotatedDisplayName) {
        this.annotatedDisplayName = annotatedDisplayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setHttpMethod(HTTPMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUriParameters(List<Parameter> uriParams) {
        this.uriParameters = uriParams;
    }

    public void setQueryParameters(List<Parameter> queryParams) {
        this.queryParameters = queryParams;
    }

    public void setHeaders(List<Parameter> headers) {
        this.headers = headers;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setInputMetadata(TypeDefinition inputMetadata) {
        this.inputMetadata = inputMetadata;
    }

    public void setOutputMetadata(TypeDefinition outputMetadata) {
        this.outputMetadata = outputMetadata;
    }

    public List<APISecurityScheme> getSecuritySchemes() {
        return securitySchemes;
    }

    public void setSecuritySchemes(List<APISecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public boolean isUserSelectedSecuritySchemes() {
        return userSelectedSecuritySchemes;
    }

    public void setUserSelectedSecuritySchemes(boolean userSelectedSecuritySchemes) {
        this.userSelectedSecuritySchemes = userSelectedSecuritySchemes;
    }
}
