package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.resourceLoader;

import static com.google.common.base.Strings.isNullOrEmpty;
import static org.slf4j.LoggerFactory.getLogger;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;

import javax.annotation.Nullable;

import org.raml.v2.api.loader.ClassPathResourceLoader;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.slf4j.Logger;

public class SafeFileResourceLoader implements ResourceLoader {

    private static final Logger LOGGER = getLogger(SafeFileResourceLoader.class);

    private final Path rootDir;
    private final ResourceLoader resourceLoader = new CompositeResourceLoader(new ClassPathResourceLoader(), new FileResourceLoader("."));

    public SafeFileResourceLoader(String rootDir){
        String basePath = rootDir != null ? rootDir : ".";

        basePath = basePath.startsWith("file://") ? basePath.substring(7) : basePath;
        this.rootDir = new File(basePath.replace("%20", " ")).toPath();
    }

    @Nullable
    @Override
    public InputStream fetchResource(String resourceName) {
        if(accepts(resourceName)){
            return resourceLoader.fetchResource(resourceName);
        }

        return null;
    }

    private boolean accepts(String resource){
        if (isNullOrEmpty(resource)) {
            return false;
        }

        try{
            String src = resource.startsWith("file://") ? resource.substring(7) : resource;
            src = src.replace("%20", " ");
            Path path = new File(src).getCanonicalFile().toPath();

            return path.startsWith(rootDir);
        }
        catch (Exception e){
            LOGGER.warn("Error evaluating resource", e);
            return false;
        }
    }

}