package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.resourceLoader;

import static java.lang.String.format;
import static org.mule.connectivity.restconnect.internal.modelGeneration.util.ResourceLoaderUtils.getHttpURLConnection;
import static org.slf4j.LoggerFactory.getLogger;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import javax.annotation.Nullable;

import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.slf4j.Logger;

public class SafeProxyResourceLoader implements ResourceLoaderExtended {

    private static final Logger LOGGER = getLogger(SafeProxyResourceLoader.class);

    private final String proxyUri;
    private final String proxyReferer;

    public SafeProxyResourceLoader(String proxyUri, String proxyReferer){
        this.proxyUri = proxyUri;
        this.proxyReferer = proxyReferer;
    }

    private URI callbackParam;

    @Override
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback)
    {
        InputStream inputStream = null;
        try
        {
            //Create a URI for the resource, so we can check if its absolute or relative.
            //We don't want to make external requests to relative resources.
            //Normalize the URI - we always send the same URL format in the requests.
            URI uri = new URI(resourceName).normalize();
            if(!uri.isAbsolute()){
                return null;
            }
            final String finalResourceUrl = (uri.getScheme() == null ? "http://" : "") + uri.toString();

            URL url = new URL(format("%s/%s", proxyUri, finalResourceUrl));
            HttpURLConnection connection = getHttpURLConnection(url, proxyReferer);

            if(connection.getResponseCode() != 200){
                return null;
            }

            inputStream = new BufferedInputStream(connection.getInputStream());

            if (callback != null)
            {
                callbackParam = url.toURI();
                callback.onResourceFound(url.toURI());
            }
        }
        catch (IOException | URISyntaxException e)
        {
            LOGGER.warn("Error fetching resource", e);
        }

        return inputStream;
    }

    @Nullable
    @Override
    public InputStream fetchResource(String resourceName)
    {
        return fetchResource(resourceName, null);
    }

    @Override
    public URI getUriCallBackParam()
    {
        return callbackParam;
    }
}
