package org.mule.connectivity.restconnect.internal.modelGeneration.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;


public class ResourceLoaderUtils {

    private static final String USER_AGENT = "rest-connect";

    /* Avoid instantiation*/
    protected ResourceLoaderUtils(){

    }

    public static HttpURLConnection getHttpURLConnection(URL url, String proxyReferer) throws IOException {
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestProperty("Referer", proxyReferer);
        return connection;
    }
}
