/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.Response;
import amf.core.client.platform.config.RenderOptions;
import amf.core.client.platform.model.domain.ArrayNode;
import amf.core.client.platform.model.domain.DataNode;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.ShapesConfiguration;
import amf.shapes.client.platform.ShapesElementClient;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.Example;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NilShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.SchemaShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import amf.xml.internal.transformer.TypeToXmlSchema;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ws.commons.schema.XmlSchema;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.XmlTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.PrimitiveMetadataModelFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;

public class AMFTypeDefinitionFactory {
    private static final Logger logger = LogManager.getLogger(AMFTypeDefinitionFactory.class);
    private static final RenderOptions RENDER_OPTIONS = new RenderOptions().withDocumentation().withCompactedEmission();
    private static final ShapesConfiguration JSON_EMITTER_CONFIGURATION = ShapesConfiguration.predefined().withRenderOptions(RENDER_OPTIONS);
    private static final ShapesElementClient JSON_EMITTER_CLIENT = JSON_EMITTER_CONFIGURATION.elementClient();

    public static TypeDefinition getTypeDefinition(Parameter parameter, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        return AMFTypeDefinitionFactory.getTypeDefinition(parameter, null, jsonSchemaPool);
    }

    public static TypeDefinition getTypeDefinition(Parameter parameter, String mediaType, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        Shape shape = AMFTypeDefinitionFactory.getParameterShape(parameter);
        if (AMFTypeDefinitionFactory.typeIsDefinedWithRAML(shape)) {
            return AMFTypeDefinitionFactory.buildJsonTypeDefinitionForParameter(parameter, mediaType, jsonSchemaPool);
        }
        if (AMFTypeDefinitionFactory.typeIsDefinedWithSchema(shape)) {
            return AMFTypeDefinitionFactory.buildTypeDefinitionForSchemaShapeParameter(parameter, mediaType, jsonSchemaPool);
        }
        if (AMFTypeDefinitionFactory.typeIsEnum(shape)) {
            return AMFTypeDefinitionFactory.buildJsonTypeDefinitionForParameter(parameter, mediaType, jsonSchemaPool);
        }
        if (AMFTypeDefinitionFactory.typeIsPrimitive(shape)) {
            return AMFTypeDefinitionFactory.buildTypeDefinitionForParameter(mediaType, parameter, PrimitiveMetadataModelFactory.createPrimitiveMetadataModel(shape));
        }
        if (shape instanceof NilShape) {
            return null;
        }
        if (AMFTypeDefinitionFactory.typeDefinitionIsNotProvided(shape)) {
            return AMFTypeDefinitionFactory.buildTypeDefinitionForParameter(mediaType, parameter, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING));
        }
        logger.warn("Type {} cannot be parsed.", shape.getClass());
        return null;
    }

    private static TypeDefinition buildTypeDefinitionForSchemaShapeParameter(Parameter parameter, String mediaType, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        SchemaShape schemaShape = (SchemaShape)AMFParserUtil.getActualShape(parameter.schema());
        if (schemaShape == null && parameter.payloads().size() > 0) {
            schemaShape = parameter.payloads().stream().filter(x -> x.schema() instanceof SchemaShape).map(Payload::schema).findFirst().orElse(null);
        }
        if (AMFTypeDefinitionFactory.isXmlSchemaShape(schemaShape)) {
            return AMFTypeDefinitionFactory.buildXmlTypeDefinitionForParameter(parameter, mediaType);
        }
        return AMFTypeDefinitionFactory.buildJsonTypeDefinitionForParameter(parameter, mediaType, jsonSchemaPool);
    }

    private static boolean isXmlSchemaShape(SchemaShape schemaShape) {
        return schemaShape.raw().nonEmpty() && schemaShape.raw().value().trim().startsWith("<");
    }

    public static TypeDefinition buildInputMetadata(Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if (operation.request() != null) {
            List payloads = operation.request().payloads();
            return AMFTypeDefinitionFactory.getDefaultTypeDefinition(payloads, jsonSchemaPool);
        }
        return null;
    }

    public static TypeDefinition buildOutputMetadata(Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        for (Response response : operation.responses()) {
            if (!response.statusCode().nonEmpty() || !response.statusCode().value().startsWith("2")) continue;
            return AMFTypeDefinitionFactory.getDefaultTypeDefinition(response.payloads(), jsonSchemaPool);
        }
        return null;
    }

    private static TypeDefinition getDefaultTypeDefinition(List<Payload> payloads, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if (payloads.size() > 0) {
            Optional<Payload> defaultPayload = payloads.stream().filter(AMFParserUtil::isDefault).findFirst();
            if (defaultPayload.isPresent()) {
                return AMFTypeDefinitionFactory.getTypeDefinitionForPayload(defaultPayload.get(), jsonSchemaPool);
            }
            return AMFTypeDefinitionFactory.getTypeDefinitionForPayload(payloads.get(0), jsonSchemaPool);
        }
        return null;
    }

    private static String getNameForPropertyShape(PropertyShape propertyShape) {
        return propertyShape.id().substring(propertyShape.id().lastIndexOf("/") + 1);
    }

    private static TypeDefinition getTypeDefinitionForPayload(Payload payload, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        String schemaContent;
        NodeShape nodeShape;
        Shape shape = AMFParserUtil.getActualShape(payload.schema());
        if ("multipart/form-data".equalsIgnoreCase(payload.mediaType().value()) && shape instanceof NodeShape && (nodeShape = (NodeShape)shape).properties().size() > 0) {
            List<PartParameter> parts = nodeShape.properties().stream().map(x -> AMFTypeDefinitionFactory.getRestConnectPartParameter(x)).collect(Collectors.toList());
            XmlSchema xmlSchema = TypeToXmlSchema.transform((String)"root", (amf.core.client.scala.model.domain.Shape)shape._internal());
            xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");
            StringWriter schemaWriter = new StringWriter();
            xmlSchema.write((Writer)schemaWriter);
            String schemaString = schemaWriter.toString();
            return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape("multipart/form-data", shape, new MultipartTypeSource(parts, new XmlTypeSource(schemaString)), true).build();
        }
        if (AMFTypeDefinitionFactory.typeIsEnum(shape) && StringUtils.isNotBlank((String)(schemaContent = JSON_EMITTER_CLIENT.buildJsonSchema((AnyShape)shape)))) {
            if (jsonSchemaPool.containsSchema(schemaContent)) {
                return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
            }
            JsonTypeSource source = new JsonTypeSource(schemaContent);
            TypeDefinition typeDefinition = AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(AMFTypeDefinitionFactory.getPayloadMediaTypeOrDefault(payload), shape, source, true).build();
            jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent, typeDefinition);
            return typeDefinition;
        }
        if (AMFTypeDefinitionFactory.typeIsDefinedWithRAML(shape) && StringUtils.isNotBlank((String)(schemaContent = JSON_EMITTER_CLIENT.buildJsonSchema((AnyShape)shape)))) {
            if (jsonSchemaPool.containsSchema(schemaContent)) {
                return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
            }
            JsonTypeSource source = new JsonTypeSource(schemaContent);
            TypeDefinition typeDefinition = AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(AMFTypeDefinitionFactory.getPayloadMediaTypeOrDefault(payload), shape, source, true).build();
            jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent, typeDefinition);
            return typeDefinition;
        }
        if (AMFTypeDefinitionFactory.typeIsDefinedWithSchema(shape)) {
            SchemaShape schemaShape = (SchemaShape)shape;
            if (AMFTypeDefinitionFactory.isXmlSchemaShape(schemaShape)) {
                String elementName = schemaShape.annotations().fragmentName().orElse(null);
                XmlTypeSource source = new XmlTypeSource(schemaShape.raw().value(), elementName, (String)schemaShape.location().get());
                return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(AMFTypeDefinitionFactory.getPayloadMediaTypeOrDefault(payload), shape, source, true).build();
            }
            String schemaContent2 = JSON_EMITTER_CLIENT.buildJsonSchema((AnyShape)shape);
            if (StringUtils.isNotBlank((String)schemaContent2)) {
                if (jsonSchemaPool.containsSchema(schemaContent2)) {
                    return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent2);
                }
                JsonTypeSource source = new JsonTypeSource(schemaContent2);
                TypeDefinition typeDefinition = AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(AMFTypeDefinitionFactory.getPayloadMediaTypeOrDefault(payload), shape, source, true).build();
                jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent2, typeDefinition);
                return typeDefinition;
            }
        }
        if (AMFTypeDefinitionFactory.typeIsPrimitive(shape)) {
            return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(AMFTypeDefinitionFactory.getPayloadMediaTypeOrDefault(payload), shape, PrimitiveMetadataModelFactory.createPrimitiveMetadataModel(shape), true).build();
        }
        if (shape instanceof NilShape) {
            return null;
        }
        if (AMFTypeDefinitionFactory.typeDefinitionIsNotProvided(shape)) {
            return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(AMFTypeDefinitionFactory.getPayloadMediaTypeOrDefault(payload), shape, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), true).build();
        }
        if (shape == null) {
            logger.warn("Type 'null' cannot be parsed.");
        } else {
            logger.warn("Type {} cannot be parsed.", shape.getClass());
        }
        return null;
    }

    private static String getPayloadMediaTypeOrDefault(Payload payload) {
        return payload.mediaType().nonEmpty() ? payload.mediaType().value() : AMFTypeDefinitionFactory.getDefaultMediaType(payload.schema());
    }

    private static String getDefaultMediaType(Shape shape) {
        if (shape instanceof FileShape) {
            return "application/octet-stream";
        }
        if (AMFTypeDefinitionFactory.typeIsDefinedWithRAML(shape)) {
            return "application/json";
        }
        if (AMFTypeDefinitionFactory.typeIsDefinedWithSchema(shape)) {
            if (AMFTypeDefinitionFactory.isXmlSchemaShape((SchemaShape)shape)) {
                return "application/xml";
            }
            return "application/json";
        }
        return "text/plain";
    }

    private static PartParameter getRestConnectPartParameter(PropertyShape x) {
        String annotatedPartContentType;
        String annotatedPartFilename;
        String annotatedPartName;
        String annotatedPartFilenameParameter;
        String name = AMFTypeDefinitionFactory.getNameForPropertyShape(x);
        Shape range = x.range();
        String defaultMediaType = AMFTypeDefinitionFactory.getDefaultMediaType(range);
        TypeDefinition typeDefinition = AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(defaultMediaType, range, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), true).build();
        PartParameter part = new PartParameter(name, ParameterType.PART, typeDefinition);
        String annotatedPartNameParameter = AMFParserUtil.getAnnotatedPartNameParameter(range);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)annotatedPartNameParameter)) {
            part.setPartNameParameterName(annotatedPartNameParameter);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(annotatedPartFilenameParameter = AMFParserUtil.getAnnotatedPartFilenameParameter(range)))) {
            part.setPartFilenameParameterName(annotatedPartFilenameParameter);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(annotatedPartName = AMFParserUtil.getAnnotatedPartName(range)))) {
            part.setPartName(annotatedPartName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(annotatedPartFilename = AMFParserUtil.getAnnotatedPartFilename(range)))) {
            part.setPartFilename(annotatedPartFilename);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(annotatedPartContentType = AMFParserUtil.getAnnotatedPartContentType(range)))) {
            part.setPartContentType(annotatedPartContentType);
        }
        return part;
    }

    private static TypeDefinition buildTypeDefinitionForParameter(String mediaType, Parameter parameter, TypeSource source) {
        Shape shape = AMFParserUtil.getActualShape(parameter.schema());
        return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(mediaType, shape, source, parameter.required().value()).withDescription(parameter.description().value()).withAnnotatedDisplayName(AMFParserUtil.getAnnotatedParameterName(parameter)).build();
    }

    private static TypeDefinitionBuilder getTypeDefinitionBuilderForShape(String mediaType, Shape shape, TypeSource source, boolean required) {
        TypeDefinitionBuilder builder = new TypeDefinitionBuilder(mediaType == null ? null : MediaType.valueOf((String)mediaType), source, required, shape instanceof ArrayShape, shape instanceof UnionShape);
        if (shape.defaultValueStr().nonEmpty()) {
            String defaultValue;
            String string = defaultValue = shape.defaultValue() instanceof ArrayNode ? ((ArrayNode)shape.defaultValue()).members().stream().map(i -> ((ScalarNode)i).value().value()).collect(Collectors.joining(",")) : shape.defaultValueStr().value();
            if (shape instanceof ScalarShape && defaultValue.startsWith("\"") && defaultValue.endsWith("\"")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            defaultValue = StringEscapeUtils.escapeJava((String)defaultValue);
            builder.withDefaultValue(defaultValue);
        }
        if (shape instanceof AnyShape) {
            AnyShape anyShape = (AnyShape)shape;
            if (!anyShape.examples().isEmpty() && ((Example)anyShape.examples().get(0)).value().nonEmpty()) {
                builder.withExample(((Example)anyShape.examples().get(0)).value().value());
            }
            if (!anyShape.values().isEmpty()) {
                builder.withEnumValues(anyShape.values().stream().map(x -> AMFTypeDefinitionFactory.getEnumValue(x)).collect(Collectors.toList()));
            }
        }
        return builder;
    }

    private static String getEnumValue(DataNode x) {
        if (x instanceof ScalarNode) {
            return ((ScalarNode)x).value().value();
        }
        throw new IllegalArgumentException("Enum type not supported");
    }

    private static TypeDefinition buildJsonTypeDefinitionForParameter(Parameter parameter, String mediaType, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        Shape shape = AMFTypeDefinitionFactory.getParameterShape(parameter);
        try {
            String schemaContent = JSON_EMITTER_CLIENT.buildJsonSchema((AnyShape)shape);
            if (StringUtils.isNotBlank((String)schemaContent)) {
                if (jsonSchemaPool.containsSchema(schemaContent)) {
                    return jsonSchemaPool.getTypeDefinitionForSchema(schemaContent);
                }
                JsonTypeSource source = new JsonTypeSource(schemaContent);
                TypeDefinition typeDefinition = AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(mediaType, shape, source, parameter.required().value()).withAnnotatedDisplayName(AMFParserUtil.getAnnotatedParameterName(parameter)).build();
                jsonSchemaPool.putSchemaTypeDefinitionPair(schemaContent, typeDefinition);
                return typeDefinition;
            }
            return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(mediaType, shape, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), parameter.required().value()).build();
        }
        catch (RuntimeException exception) {
            logger.warn("Couldn't generate a type definition for " + parameter.name(), (Throwable)exception);
            return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(mediaType, shape, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), parameter.required().value()).build();
        }
    }

    private static Shape getParameterShape(Parameter parameter) {
        Shape shape = AMFParserUtil.getActualShape(parameter.schema());
        if (shape == null && parameter.payloads().size() > 0) {
            shape = parameter.payloads().stream().filter(x -> x.schema() != null).map(Payload::schema).findFirst().orElse(null);
        }
        return shape;
    }

    private static TypeDefinition buildXmlTypeDefinitionForParameter(Parameter parameter, String mediaType) {
        Shape shape = AMFTypeDefinitionFactory.getParameterShape(parameter);
        try {
            SchemaShape schemaShape = (SchemaShape)shape;
            String elementName = schemaShape.annotations().fragmentName().orElse(null);
            XmlTypeSource source = new XmlTypeSource(schemaShape.raw().value(), elementName, (String)schemaShape.location().get());
            TypeDefinitionBuilder builder = AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(mediaType, shape, source, parameter.required().value());
            return builder.build();
        }
        catch (RuntimeException exception) {
            logger.warn("Couldn't generate a type definition for " + parameter.name(), (Throwable)exception);
            return AMFTypeDefinitionFactory.getTypeDefinitionBuilderForShape(mediaType, shape, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), parameter.required().value()).build();
        }
    }

    public static boolean typeIsDefinedWithSchema(Shape shape) {
        return shape instanceof SchemaShape;
    }

    private static boolean typeIsEnum(Shape shape) {
        return shape instanceof AnyShape && !shape.values().isEmpty();
    }

    public static boolean typeIsDefinedWithRAML(Shape shape) {
        return shape instanceof NodeShape || shape instanceof ArrayShape || shape instanceof UnionShape;
    }

    public static boolean typeIsPrimitive(Shape shape) {
        return shape instanceof ScalarShape || shape instanceof FileShape;
    }

    public static boolean typeDefinitionIsNotProvided(Shape shape) {
        return shape instanceof AnyShape && !AMFTypeDefinitionFactory.typeIsDefinedWithRAML(shape) && !AMFTypeDefinitionFactory.typeIsPrimitive(shape) && !AMFTypeDefinitionFactory.typeIsDefinedWithSchema(shape);
    }
}

