package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit;

import com.google.common.collect.ImmutableList;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.PojoFQNamePool;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

import java.util.List;
import java.util.Map;

public class DevKitPassThroughSchemeDecorator extends DevKitSecuritySchemeDecorator {

    private List<DevKitConnectorTypeDefinitionDecorator> decoratedQueryParameters;
    private List<DevKitConnectorTypeDefinitionDecorator> decoratedHeaders;
    private final PojoFQNamePool pojoFQNamePool;

    public DevKitPassThroughSchemeDecorator(APISecurityScheme securityScheme, Map<APISecurityScheme, String> securitySchemesNames, PojoFQNamePool pojoFQNamePool) {
        super(securityScheme, securitySchemesNames);
        this.pojoFQNamePool = pojoFQNamePool;
        this.decoratedQueryParameters = buildDecoratedQueryParameters();
        this.decoratedHeaders = buildDecoratedHeaders();
    }

    @Override
    public String getTemplateLocation() {
        return "templates/devkit/PassThroughConfig.vm";
    }

    @Override
    public String getDefaultConfigName() {
        return "PassThroughConfig";
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedConnectorQueryParameters(){
        return decoratedQueryParameters;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedConnectorHeaders(){
        return decoratedHeaders;
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedQueryParameters(){
        ImmutableList.Builder<DevKitConnectorTypeDefinitionDecorator> builder = ImmutableList.builder();

        for (Parameter queryParam : getApiSecurityScheme().getQueryParameters()) {
            builder.add(new DevKitConnectorTypeDefinitionDecorator(queryParam.getExternalName(), queryParam.getInternalName(), queryParam.getTypeDefinition(),"dummy-package", pojoFQNamePool));
        }

        return builder.build();
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedHeaders() {
        ImmutableList.Builder<DevKitConnectorTypeDefinitionDecorator> builder = ImmutableList.builder();

        for (Parameter header : getApiSecurityScheme().getHeaders()) {
            builder.add(new DevKitConnectorTypeDefinitionDecorator(header.getExternalName(), header.getInternalName(), header.getTypeDefinition(),"dummy-package", pojoFQNamePool));
        }

        return builder.build();
    }

}
