package org.mule.connectivity.restconnect.internal.util;

import com.google.common.base.CaseFormat;

import static com.google.common.base.CaseFormat.*;
import static java.lang.Character.isUpperCase;

public class TemplateUtils {

    public static String toUpperCamel(String input) {
        return convert(UPPER_CAMEL, input);
    }

    public static String toLowerCamel(String input) {
        return convert(LOWER_CAMEL, input);
    }

    public static String toUpperUnderscore(String input) {
        return convert(UPPER_UNDERSCORE, input);
    }

    public static String toLowerUnderscore(String input) {
        return convert(LOWER_UNDERSCORE, input);
    }

    private static String convert(CaseFormat targetFormat, String input) {
        String nullSafeInput = String.valueOf(input);
        return CaseFormat.valueOf(String.format("%s_%s", isUpperCase(nullSafeInput.charAt(0)) ? "UPPER" : "LOWER", nullSafeInput.contains("_") ? "UNDERSCORE" : "CAMEL")).to(targetFormat, nullSafeInput);
    }
}
