/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.typesource;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlTypeSource
implements TypeSource {
    private String value;
    private String elementName;
    private String schemaPath;
    private boolean wasSchemaParsed = false;
    private static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static DocumentBuilderFactory dbf = null;

    public XmlTypeSource(String schemaContent) {
        this.value = schemaContent;
        this.elementName = null;
        this.schemaPath = null;
    }

    public XmlTypeSource(String schemaContent, String elementName, String schemaPath) {
        this.value = schemaContent;
        this.elementName = elementName;
        this.schemaPath = schemaPath;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public String getElementName() throws GenerationException {
        if (!(this.wasSchemaParsed || this.elementName != null && this.elementName.startsWith("{"))) {
            this.elementName = this.getElementQName(this.elementName);
        }
        return this.elementName;
    }

    private String getElementQName(String elementName) throws GenerationException {
        try {
            InputSource inputSource = new InputSource(new StringReader(this.value));
            Document doc = null;
            doc = this.parseDoPriv(inputSource, XmlTypeSource.getSecureDocumentBuilder(), doc);
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            if (StringUtils.isNotBlank((String)this.schemaPath)) {
                schemaCol.setBaseUri(new File(this.schemaPath).getParent());
            }
            XmlSchema schema = schemaCol.read(doc, inputSource.getSystemId(), null);
            String result = null;
            if (!schema.getElements().keySet().isEmpty()) {
                Optional<QName> optional;
                result = elementName == null ? schema.getElements().keySet().toArray()[0].toString() : ((optional = schema.getElements().keySet().stream().filter(ks -> elementName.equals(ks.getLocalPart())).findFirst()).isPresent() ? optional.get().toString() : elementName);
            }
            this.wasSchemaParsed = true;
            return result;
        }
        catch (IOException | SAXException e) {
            throw new GenerationException("Could not parse XML element.\n " + this.value);
        }
    }

    private Document parseDoPriv(InputSource inputSource, DocumentBuilder builder, Document doc) throws IOException, SAXException {
        block3: {
            try {
                doc = AccessController.doPrivileged(() -> builder.parse(inputSource));
            }
            catch (PrivilegedActionException e) {
                Exception exception = e.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof SAXException)) break block3;
                throw (SAXException)exception;
            }
        }
        return doc;
    }

    private static DocumentBuilder getSecureDocumentBuilder() throws GenerationException {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                dbf.setFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE, false);
                dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, false);
                dbf.setFeature(LOAD_EXTERNAL_DTD_FEATURE, false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                dbf.setNamespaceAware(true);
            }
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GenerationException("Could not configure document builder", e);
        }
    }
}

