/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.util;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.apicontract.client.platform.model.domain.security.SecurityScheme;
import amf.core.client.platform.model.domain.DomainElement;
import amf.core.client.platform.model.domain.DomainExtension;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;

public class AMFParserUtil
extends ParserUtils {
    private static final String RC_PREFIX = "rest-connect.";
    private static final String RC_IGNORE_ANNOTATION = "rest-connect.ignored";
    private static final String RC_DEFAULT_ANNOTATION = "rest-connect.default";
    private static final String RC_USER_SELECTED_SECURITY_SCHEMES_ANNOTATION = "rest-connect.userSelectedSecuritySchemes";
    private static final String RC_PARAMETER_NAME_ANNOTATION = "rest-connect.parameterName";
    private static final String RC_OPERATION_NAME_ANNOTATION = "rest-connect.operationName";
    private static final String RC_RENEW_TOKEN_EXPRESSION_ANNOTATION = "rest-connect.renewTokenExpression";
    private static final String RC_PART_CONTENT_TYPE_ANNOTATION = "rest-connect.partContentType";
    private static final String RC_PART_FILENAME_ANNOTATION = "rest-connect.partFilename";
    private static final String RC_PART_NAME_ANNOTATION = "rest-connect.partName";
    private static final String RC_PART_FILENAME_PARAMETER_ANNOTATION = "rest-connect.partFilenameParameter";
    private static final String RC_PART_NAME_PARAMETER_ANNOTATION = "rest-connect.partNameParameter";

    public static String getMethodDisplayName(Operation operation) {
        String displayName = null;
        if (operation.name().nonEmpty() && !operation.name().value().equalsIgnoreCase(operation.method().value())) {
            displayName = operation.name().value();
        }
        return StringUtils.trimToNull(displayName);
    }

    public static String getCanonicalOperationName(EndPoint endPoint, Operation operation, String friendlyName) {
        String annotatedOperationName = AMFParserUtil.getAnnotatedOperationName(operation);
        HTTPMethod httpMethod = HTTPMethod.fromString(operation.method().value());
        return AMFParserUtil.getCanonicalOperationName(httpMethod, endPoint.path().value(), friendlyName, annotatedOperationName);
    }

    public static String getAnnotatedParameterName(amf.apicontract.client.platform.model.domain.Parameter parameter) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)parameter, RC_PARAMETER_NAME_ANNOTATION);
    }

    public static String getAnnotatedOperationName(Operation operation) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)operation, RC_OPERATION_NAME_ANNOTATION);
    }

    public static String getAnnotatedRenewTokenExpression(SecurityScheme securityScheme) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)securityScheme, RC_RENEW_TOKEN_EXPRESSION_ANNOTATION);
    }

    public static String getAnnotatedPartContentType(Shape element) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)element, RC_PART_CONTENT_TYPE_ANNOTATION);
    }

    public static String getAnnotatedPartFilename(Shape element) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)element, RC_PART_FILENAME_ANNOTATION);
    }

    public static String getAnnotatedPartName(Shape element) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)element, RC_PART_NAME_ANNOTATION);
    }

    public static String getAnnotatedPartFilenameParameter(Shape element) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)element, RC_PART_FILENAME_PARAMETER_ANNOTATION);
    }

    public static String getAnnotatedPartNameParameter(Shape element) {
        return AMFParserUtil.getStringAnnotationForElement((DomainElement)element, RC_PART_NAME_PARAMETER_ANNOTATION);
    }

    public static String getStringAnnotationForElement(DomainElement element, String annotationName) {
        String stringValue = AMFParserUtil.getAnnotationForElement(element, annotationName);
        if (StringUtils.isNotBlank((CharSequence)stringValue)) {
            return stringValue;
        }
        return null;
    }

    public static String getAnnotationForElement(DomainElement element, String annotationName) {
        Optional<DomainExtension> optionalDomainExtension = element.customDomainProperties().stream().filter(x -> x.name().nonEmpty() && annotationName.equalsIgnoreCase(x.name().value())).findFirst();
        if (!optionalDomainExtension.isPresent()) {
            return null;
        }
        DomainExtension domainExtension = optionalDomainExtension.get();
        return ((ScalarNode)domainExtension.extension()).value().value();
    }

    public static boolean elementContainsAnnotation(DomainElement element, String annotationName) {
        return element.customDomainProperties().stream().anyMatch(x -> x.name().nonEmpty() && annotationName.equalsIgnoreCase(x.name().value()));
    }

    public static boolean isDefault(Payload payload) {
        if (payload.schema() == null) {
            return false;
        }
        return AMFParserUtil.elementContainsAnnotation((DomainElement)payload.schema(), RC_DEFAULT_ANNOTATION);
    }

    public static boolean isIgnored(EndPoint endPoint, Operation operation) {
        return AMFParserUtil.elementContainsAnnotation((DomainElement)endPoint, RC_IGNORE_ANNOTATION) || AMFParserUtil.elementContainsAnnotation((DomainElement)operation, RC_IGNORE_ANNOTATION);
    }

    public static boolean isUserSelectedSecuritySchemes(EndPoint endPoint, Operation operation, WebApi api) {
        return AMFParserUtil.elementContainsAnnotation((DomainElement)endPoint, RC_USER_SELECTED_SECURITY_SCHEMES_ANNOTATION) || AMFParserUtil.elementContainsAnnotation((DomainElement)operation, RC_USER_SELECTED_SECURITY_SCHEMES_ANNOTATION) || AMFParserUtil.elementContainsAnnotation((DomainElement)api, RC_USER_SELECTED_SECURITY_SCHEMES_ANNOTATION);
    }

    public static List<Parameter> getParameterList(List<amf.apicontract.client.platform.model.domain.Parameter> amfParameters, ParameterType parameterType, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        for (amf.apicontract.client.platform.model.domain.Parameter amfParameter : amfParameters) {
            parameters.add(new Parameter(amfParameter.parameterName().value(), parameterType, AMFTypeDefinitionFactory.getTypeDefinition(amfParameter, jsonSchemaPool)));
        }
        return parameters;
    }

    public static Shape getActualShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape.isLink() && shape.linkTarget().isPresent()) {
            return AMFParserUtil.getActualShape((Shape)shape.linkTarget().get());
        }
        return shape;
    }
}

