/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;
import org.mule.connectivity.restconnect.internal.util.JavaRequestUtils;

public abstract class TemplateEngine {
    protected static ToolManager velocityToolManager = new ToolManager();

    public abstract void applyTemplates() throws Exception;

    protected Path applyTemplate(String templateVm, Path output, VelocityContext context) throws IOException {
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        context.put("StringUtils", StringUtils.class);
        context.put("DataWeaveUtils", DataWeaveUtils.class);
        context.put("JavaRequestUtils", JavaRequestUtils.class);
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loaders", (Object)"classpath");
        ve.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        Template template = ve.getTemplate(templateVm, "UTF-8");
        try (BufferedWriter writer = Files.newBufferedWriter(output, new OpenOption[0]);){
            template.merge((Context)context, (Writer)writer);
        }
        return output;
    }

    protected void checkPomIsConsistent(Path pomPath) throws GenerationException {
        try (InputStream is = Files.newInputStream(pomPath, new OpenOption[0]);){
            new MavenXpp3Reader().read(is);
        }
        catch (Exception e) {
            throw new GenerationException("Error while checking pom consistency of file '" + pomPath + '\'', e);
        }
    }

    static {
        velocityToolManager.configure("velocity-tools.xml");
    }
}

