/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import java.util.Arrays;
import org.mule.connectivity.restconnect.internal.model.security.naming.OAS2SecuritySchemes;

public class AMFSecuritySchemesNaming {
    public static boolean isOauth1(String name) {
        return "OAuth 1.0".equalsIgnoreCase(name);
    }

    public static boolean isOauth2(String name) {
        return "oauth2".equalsIgnoreCase(name) || "OAuth 2.0".equalsIgnoreCase(name) || "OAuth 2.0".equalsIgnoreCase(name);
    }

    public static boolean isPassThrough(String name) {
        return "Pass Through".equalsIgnoreCase(name);
    }

    public static boolean isApiKey(String name) {
        return "apiKey".equalsIgnoreCase(name) || Arrays.stream(OAS2SecuritySchemes.API_KEY).anyMatch(x -> x.equalsIgnoreCase(name));
    }

    public static boolean isBasicAuth(String name, String schema) {
        return "http".equalsIgnoreCase(name) && "basic".equalsIgnoreCase(schema) || "Basic Authentication".equalsIgnoreCase(name) || "Basic Authentication".equalsIgnoreCase(name);
    }

    public static boolean isDigestAuth(String name) {
        return "Digest Authentication".equalsIgnoreCase(name);
    }

    public static boolean isJwtAuth(String name) {
        return "Jwt".equalsIgnoreCase(name) || "x-Jwt".equalsIgnoreCase(name);
    }

    public static boolean isBearerAuth(String name, String schema) {
        return "http".equalsIgnoreCase(name) && "bearer".equalsIgnoreCase(schema);
    }

    public static boolean isCustom(String name, String schema) {
        return !"apiKey".equalsIgnoreCase(name) && (!"http".equalsIgnoreCase(name) || !"basic".equalsIgnoreCase(schema)) && !"oauth2".equalsIgnoreCase(name) && !"Basic Authentication".equalsIgnoreCase(name) && !AMFSecuritySchemesNaming.isApiKey(name) && !"OAuth 2.0".equalsIgnoreCase(name) && !"Basic Authentication".equalsIgnoreCase(name) && !"OAuth 1.0".equalsIgnoreCase(name) && !"OAuth 2.0".equalsIgnoreCase(name) && !"Pass Through".equalsIgnoreCase(name) && !"Digest Authentication".equalsIgnoreCase(name) && !AMFSecuritySchemesNaming.isJwtAuth(name) && !AMFSecuritySchemesNaming.isBearerAuth(name, schema);
    }
}

