package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model;

import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;

import java.util.List;

public class SmartConnectorSecuritySchemeHelper {

    public static APISecurityScheme getPrioritarySecurityScheme(List<APISecurityScheme> schemes){
        //Returns the most prioritary security scheme from a list.
        //TODO: This should be removed when support for multiple security schemes is added.//

        if(schemes == null || schemes.size() == 0){
            return new UnsecuredScheme();
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.BASIC)){
                return scheme;
            }
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.OAUTH2)){
                for(String grant : ((OAuth2Scheme)scheme).getAuthorizationGrants()){
                    if(grant.equals(OAuth2Scheme.OAUTH2_GRANT_CLIENT_CREDENTIALS)){
                        return scheme;
                    }
                }
            }
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.OAUTH2)){
                for(String grant : ((OAuth2Scheme)scheme).getAuthorizationGrants()){
                    if(grant.equals(OAuth2Scheme.OAUTH2_GRANT_AUTHORIZATION_CODE)){
                        return scheme;
                    }
                }
            }
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.PASS_THROUGH)){
                return scheme;
            }
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.DIGEST_AUTHENTICATION)){
                return scheme;
            }
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.CUSTOM_AUTHENTICATION)){
                return scheme;
            }
        }

        for (APISecurityScheme scheme : schemes) {
            if(scheme.getSchemeName().equals(APISecurityScheme.UNSECURED)){
                return scheme;
            }
        }

        return schemes.get(0);
    }
}
