package org.mule.connectivity.restconnect.internal.model.security;

import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class OAuth2ClientCredentialsScheme extends OAuth2Scheme {

    public OAuth2ClientCredentialsScheme(String authorizationUri, String accessTokenUri, List<String> grants, List<String> scopes, String renewTokenExpression) {
        super(authorizationUri, accessTokenUri, grants, scopes, renewTokenExpression);
    }

    @Override
    public void initializeConfigParameters() {
        configParameters = new LinkedList<>();

        configParameters.addAll(Arrays.asList(
                getSecuritySchemeParameter("clientId", "clientId", PrimitiveTypeSource.PrimitiveType.STRING, "OAuth2 Client Id", null, null, true, false),
                getSecuritySchemeParameter("clientSecret", "clientSecret", PrimitiveTypeSource.PrimitiveType.STRING, "OAuth2 Client Secret", null, null, true, true),
                getSecuritySchemeParameter("accessTokenUrl", "accessTokenUrl", PrimitiveTypeSource.PrimitiveType.STRING, "Token URL for consuming API", getAccessTokenUri(), getAccessTokenUri(), true, false)
        ));

        addScopeConfigParameter();
    }
}
