package org.mule.connectivity.restconnect.internal.model.uri;

import org.apache.commons.lang3.StringUtils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseUri {
    private URI uri;
    private List<String> parameters = new LinkedList<>();

    public BaseUri(String uriStr) throws URISyntaxException {
        this.parameters = extractCustomUriParameters(uriStr);
        this.uri = new URI(getDeparametrizedString(uriStr));
    }

    private String getDeparametrizedString(String str){
        String deparametrizedString = str;

        if(StringUtils.isEmpty(deparametrizedString)){
            return deparametrizedString;
        }

        for(String param : parameters){
            deparametrizedString = deparametrizedString.replace("{" + param + "}", "beginparam" + param + "endparam");
        }

        return deparametrizedString;
    }

    private String getParametrizedString(String str){
        String parametrizedString = str;

        if(StringUtils.isEmpty(parametrizedString)){
            return parametrizedString;
        }

        for(String param : parameters){
            parametrizedString = parametrizedString.replace("beginparam" + param + "endparam", "[" + param + "]");
        }

        return parametrizedString;
    }

    private static List<String> extractCustomUriParameters(String uriString){
        Pattern pattern = Pattern.compile("(\\{.*\\})");
        Matcher matcher = pattern.matcher(uriString);

        List<String> parameters = new LinkedList<>();
        while(matcher.find()) {
            String matchedString = matcher.group(1).substring(1);
            matchedString = matchedString.substring(0, matchedString.length() - 1);
            parameters.add(matchedString);
        }

        return parameters;
    }

    public boolean isAbsolute() {
        return uri.isAbsolute();
    }

    public String getPath() {
        return getParametrizedString(uri.getPath());
    }

    public String getScheme() {
        return getParametrizedString(uri.getScheme());
    }

    public String getHost() {
        return getParametrizedString(uri.getHost());
    }

    public Integer getPort() {
        return uri.getPort();
    }

    @Override
    public String toString() {
        if(StringUtils.isNotBlank(uri.toString())){
            return getParametrizedString(uri.toString());
        }
        return "";
    }
}
