/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import java.util.HashMap;
import java.util.Map;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public class PrimitiveMetadataModelFactory {
    private static final Map<String, PrimitiveTypeSource.PrimitiveType> scalarTypeMappings = new HashMap<String, PrimitiveTypeSource.PrimitiveType>();

    private PrimitiveMetadataModelFactory() {
    }

    public static PrimitiveTypeSource createPrimitiveMetadataModel(Shape shape) {
        PrimitiveTypeSource.PrimitiveType primitiveType = null;
        if (shape instanceof ScalarShape) {
            primitiveType = scalarTypeMappings.get(((ScalarShape)shape).dataType().value());
        } else if (shape instanceof FileShape) {
            primitiveType = PrimitiveTypeSource.PrimitiveType.FILE;
        }
        return new PrimitiveTypeSource(primitiveType);
    }

    static {
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#boolean", PrimitiveTypeSource.PrimitiveType.BOOLEAN);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#float", PrimitiveTypeSource.PrimitiveType.NUMBER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#double", PrimitiveTypeSource.PrimitiveType.NUMBER);
        scalarTypeMappings.put("http://a.ml/vocabularies/shapes#number", PrimitiveTypeSource.PrimitiveType.NUMBER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#integer", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#long", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#byte", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#short", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedByte", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedInt", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedLong", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedShort", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#positiveInteger", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#negativeInteger", PrimitiveTypeSource.PrimitiveType.INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#string", PrimitiveTypeSource.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#base64Binary", PrimitiveTypeSource.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#hexBinary", PrimitiveTypeSource.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#token", PrimitiveTypeSource.PrimitiveType.STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#dateTime", PrimitiveTypeSource.PrimitiveType.DATE_TIME);
        scalarTypeMappings.put("http://a.ml/vocabularies/shapes#dateTimeOnly", PrimitiveTypeSource.PrimitiveType.DATE_TIME_ONLY);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#date", PrimitiveTypeSource.PrimitiveType.DATE_ONLY);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#time", PrimitiveTypeSource.PrimitiveType.TIME_ONLY);
    }
}

