/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.model.typesource.JsonTypeSource;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.ModelDecorator;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationDecorator {
    protected final Operation operation;
    protected final ModelDecorator modelDecorator;
    protected Boolean inputMetadataTooLong = null;
    protected Boolean outputMetadataTooLong = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationDecorator.class);

    public OperationDecorator(Operation operation, ModelDecorator modelDecorator) {
        this.operation = operation;
        this.modelDecorator = modelDecorator;
    }

    public TypeDefinition getInputMetadata() {
        TypeDefinition inputMetadata = this.operation.getInputMetadata();
        if (this.inputMetadataTooLong == null) {
            this.inputMetadataTooLong = this.isMetadataTooLong(inputMetadata);
        }
        if (this.inputMetadataTooLong.booleanValue()) {
            return TypeDefinitionBuilder.buildStringTypeWithMediaType(inputMetadata.getMediaType(), inputMetadata.isRequired());
        }
        return inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        TypeDefinition outputMetadata = this.operation.getOutputMetadata();
        if (this.outputMetadataTooLong == null) {
            this.outputMetadataTooLong = this.isMetadataTooLong(outputMetadata);
        }
        if (this.outputMetadataTooLong.booleanValue()) {
            return TypeDefinitionBuilder.buildStringTypeWithMediaType(outputMetadata.getMediaType(), outputMetadata.isRequired());
        }
        return outputMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMetadataTooLong(TypeDefinition metadata) {
        if (metadata == null || metadata.getSource() == null || !(metadata.getSource() instanceof JsonTypeSource) || StringUtils.isBlank((String)metadata.getSource().getValue())) {
            return false;
        }
        Callable<Boolean> isMetadataLoaded = () -> {
            JsonTypeLoader jsonTypeLoader = new JsonTypeLoader(metadata.getSource().getValue());
            Optional metadataType1 = jsonTypeLoader.load(null);
            Optional metadataType2 = jsonTypeLoader.load(null);
            if (metadataType1.isPresent() && metadataType1.equals(metadataType2)) {
                return true;
            }
            return !Thread.interrupted();
        };
        boolean validMetadata = true;
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<Boolean> isMetadataLoadedTask = executorService.submit(isMetadataLoaded);
        try {
            isMetadataLoadedTask.get(200L, TimeUnit.MILLISECONDS);
            LOGGER.debug("[" + this.modelDecorator.getGAV() + "]Metadata loaded. Length: " + metadata.getSource().getValue().length());
        }
        catch (InterruptedException | CancellationException | TimeoutException e) {
            LOGGER.warn("[" + this.modelDecorator.getGAV() + "]Error: Metadata check timed out. Length: " + metadata.getSource().getValue().length());
            validMetadata = false;
        }
        catch (ExecutionException e) {
            LOGGER.warn("[" + this.modelDecorator.getGAV() + "]Error: Invalid metadata.");
            validMetadata = false;
        }
        finally {
            isMetadataLoadedTask.cancel(true);
            executorService.shutdownNow();
        }
        return !validMetadata;
    }

    public List<Parameter> getQueryParameters() {
        return this.operation.getQueryParameters();
    }

    public List<Parameter> getUriParameters() {
        return this.operation.getUriParameters();
    }

    public List<Parameter> getPartParameters() {
        return this.operation.getPartParameters();
    }

    public List<Parameter> getHeaders() {
        return this.operation.getHeaders();
    }

    public List<Parameter> getParameters() {
        return this.operation.getParameters();
    }

    public boolean hasQueryParameters() {
        return !this.getQueryParameters().isEmpty();
    }

    public boolean hasUriParameters() {
        return !this.getUriParameters().isEmpty();
    }

    public boolean hasHeaders() {
        return !this.getHeaders().isEmpty();
    }

    public String getCanonicalName() {
        return this.operation.getCanonicalName();
    }

    public String getFriendlyName() {
        return this.operation.getFriendlyName();
    }

    public String getAnnotatedDisplayName() {
        return this.operation.getAnnotatedDisplayName();
    }

    public String getHttpMethod() {
        return this.operation.getHttpMethod();
    }

    public String getUri() {
        return this.operation.getUri();
    }
}

