/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.PojoFQNamePool;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit.DevKitSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

public class DevKitCustomAuthenticationSchemeDecorator
extends DevKitSecuritySchemeDecorator {
    private List<DevKitConnectorTypeDefinitionDecorator> decoratedQueryParameters;
    private List<DevKitConnectorTypeDefinitionDecorator> decoratedHeaders;
    private PojoFQNamePool pojoFQNamePool;

    public DevKitCustomAuthenticationSchemeDecorator(APISecurityScheme securityScheme, Map<APISecurityScheme, String> securitySchemesNames, PojoFQNamePool pojoFQNamePool) {
        super(securityScheme, securitySchemesNames);
        this.pojoFQNamePool = pojoFQNamePool;
        this.decoratedQueryParameters = this.buildDecoratedQueryParameters();
        this.decoratedHeaders = this.buildDecoratedHeaders();
    }

    @Override
    public String getTemplateLocation() {
        return "templates/devkit/CustomAuthenticationConfig.vm";
    }

    @Override
    public String getDefaultConfigName() {
        return "CustomAuthenticationConfig";
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedConnectorQueryParameters() {
        return this.decoratedQueryParameters;
    }

    public List<DevKitConnectorTypeDefinitionDecorator> getDecoratedConnectorHeaders() {
        return this.decoratedHeaders;
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedQueryParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter queryParam : this.getApiSecurityScheme().getQueryParameters()) {
            builder.add((Object)new DevKitConnectorTypeDefinitionDecorator(queryParam.getExternalName(), queryParam.getInternalName(), queryParam.getTypeDefinition(), "dummy-package", this.pojoFQNamePool));
        }
        return builder.build();
    }

    private List<DevKitConnectorTypeDefinitionDecorator> buildDecoratedHeaders() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter header : this.getApiSecurityScheme().getHeaders()) {
            builder.add((Object)new DevKitConnectorTypeDefinitionDecorator(header.getExternalName(), header.getInternalName(), header.getTypeDefinition(), "dummy-package", this.pojoFQNamePool));
        }
        return builder.build();
    }
}

