package org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader;

import static org.slf4j.LoggerFactory.getLogger;

import java.io.File;
import java.nio.file.Path;

import amf.client.resource.FileResourceLoader;
import org.slf4j.Logger;

public class SafeFileResourceLoader extends FileResourceLoader {

  private static final Logger LOGGER = getLogger(SafeFileResourceLoader.class);

  private Path rootDir;

  public SafeFileResourceLoader(String rootDir){
    super();

    String basePath = rootDir != null ? rootDir : ".";

    basePath = basePath.startsWith("file://") ? basePath.substring(7) : basePath;
    this.rootDir = new File(basePath.replace("%20", " ")).toPath();
  }

  @Override
  public boolean accepts(final String resource){

    try{
      if(super.accepts(resource)){
      String src = resource.startsWith("file://") ? resource.substring(7) : resource;
      src = src.replace("%20", " ");
      Path path = new File(src).getCanonicalFile().toPath();

      return path.startsWith(rootDir);
    }
  }
    catch (Exception e){
    LOGGER.warn("Error evaluating resource", e);
    return false;
  }

    return false;
  }
}