package org.mule.connectivity.restconnect.internal.model.security;

import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;

import java.util.List;

public class JwtRandomizableStrategy {
    private final long minLength;
    private final long maxLength;
    private final boolean onlyNumbers;

    public JwtRandomizableStrategy(List<TypeInstanceProperty> properties) {
        this.minLength = properties.stream().filter(property -> property.name().equals("minimumCharacters"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::value)
                .map(Long.class::cast)
                .orElse(0L);
        this.maxLength = properties.stream().filter(property -> property.name().equals("maximumCharacters"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::value)
                .map(Long.class::cast)
                .orElse(16L);
        this.onlyNumbers = properties.stream().filter(property -> property.name().equals("onlyNumbers"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::value)
                .map(Boolean.class::cast)
                .orElse(false);
    }

    public long getMaxLength() {
        return maxLength;
    }

    public long getMinLength() {
        return minLength;
    }

    public boolean isOnlyNumbers() {
        return onlyNumbers;
    }
}
