package org.mule.connectivity.restconnect.internal.modelGeneration.util;

import static org.apache.commons.lang.StringUtils.isBlank;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;


public class ResourceLoaderUtils {

    private static final String USER_AGENT = "rest-connect";

    /* Avoid instantiation*/
    protected ResourceLoaderUtils(){

    }

    public static HttpURLConnection getHttpURLConnection(URL url, String proxyReferer, String token,
                                                         String orgId) throws IOException {
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestProperty("Referer", proxyReferer);
        // both headers are exclusive
        if(!isBlank(token)) {
            connection.setRequestProperty("ms-authorization", String.format("Bearer %s", token));
        } else if(!isBlank(orgId)) {
            connection.addRequestProperty("ms-organization-id", orgId);
        }

        return connection;
    }
}
